#include "mbed.h"
#include "LedBlink.h"
Ticker LedTicker; 
volatile float led_timer = 0;
bool ChangeStatusFlag = false;

LedBlink::LedBlink(PinName pin) :_pin(pin) {
    _pin = 1;
    }
    
void LedBlink::LedBlinkCallback(void) {
    if (led_timer == 0){
        _pin = 1;
        }
    if (led_timer != 0){ 
        _pin = !_pin;
        if (ChangeStatusFlag) {
            // re-task ticker flash rate
            LedTicker.detach(); 
            LedTicker.attach(this, &LedBlink::LedBlinkCallback,led_timer); 
            ChangeStatusFlag = false;
        }
    }   
} 

void LedBlink::Blinker(float frequency){
    led_timer = frequency;
    ChangeStatusFlag = true;
    LedBlinkCallback();
} 