#include "mbed.h"

/**
    Due to the imperfect design of the buttons, a press on the button is registered multple times.
    The debouncer module makes sure that these false positives of the button are going to be ignored.
    
    Also, this module provides a multiclick service which allows the user to press the button multiple times 
    within a certain time frame. Therefore, multiple actions can be mapped to a single button.
    
*/

extern volatile bool button1_pressed;   // Used in the main loop
extern volatile bool button1_enabled;   // Used for debouncing
extern volatile int multiclick_state;   // Counts how many clicks occured in the time slot, used in main loop
extern volatile bool button1_busy;      // Informs the mainloop that the user is clicking the button

void button1_multiclick_reset_cb(void); // Resets the amount of clicks, but stores this value for the usage in the main loop
void button1_enabled_cb(void);          // Enables the button again after a timeout, used for debouncing the button 
void button1_onpressed_cb(void);        // Callback which is called when the user presses the button