#include "debounce_button.h"

/**
    Some tips and tricks:
    -   To use the built-in LED:
            DigitalOut led1(LED1);
            ...
            led1 = 1;
    -   To delay the call of a function:
            Timeout someTimeout;
            ...
            someTimeout.attach(callback(&someFunction), 0.5) with 0.5 as 500 milliseconds
    -   The variables that are used in interrupt callbacks have to be volatile, 
        because these variables can change at any time. Therefore, the compiler is not 
        going to make optimisations.
*/

/**
    TODO
    ----
    This function:
        -   stores the amount of clicks in a variable which is read by the main loop.
        -   resets the click counter which is used inside this file.
        -   lowers a flag which tells the main loop that the user stopped pressing the button
            such that it can proceed its program.
        -   turns the built-in LED off. Therefore, the user gets informed that the program stopped counting the clicks.
*/
void button1_multiclick_reset_cb(void) {
    
}

/**
    TODO
    ----
    This function enables the button again, such that unwanted clicks of the bouncing button get ignored.
*/
void button1_enabled_cb(void)
{
    
}

/**
    TODO
    ----
    This function:
        -   turns the built-in LED on, so the user gets informed that the program has started with counting clicks
        -   disables the button such that the debouncer is active
        -   enables the button again after a certain amount of time 
            (use interrupts with "button1_enabled_cb()" as callback.
        -   counts the amount of clicks within a period of 1 second
        -   informs the main loop that the button has been pressed
        -   informs the main loop that the user is clicking the button.
            Therefore, this main loop cannot continue its procedure until the clicks within 1 second have been counted.
*/
void button1_onpressed_cb(void)
{
    
}