#ifndef __SI114x_H__
#define __SI114x_H__

#include"mbed.h"
#include<string>

// TODO: integrate proper calibration code
// TODO: compensate Vis by IR
// TODO: auto mode

// DONE: auto-adjust range

class SI114x {
public:
    /// COMMANDS
    static const uint8_t    CMD_PARAM_QUERY;
    static const uint8_t    CMD_PARAM_SET;
    static const uint8_t    CMD_NOP;
    static const uint8_t    CMD_RESET;
    static const uint8_t    CMD_BUSADDR;
    static const uint8_t    CMD_PS_FORCE;
    static const uint8_t    CMD_GET_CAL;
    static const uint8_t    CMD_GET_CAL_INDEX;
    static const uint8_t    CMD_ALS_FORCE;
    static const uint8_t    CMD_PSALS_FORCE;
    static const uint8_t    CMD_PS_PAUSE;
    static const uint8_t    CMD_ALS_PAUSE;
    static const uint8_t    CMD_PSALS_PAUSE;
    static const uint8_t    CMD_PS_AUTO;
    static const uint8_t    CMD_ALS_AUTO;
    static const uint8_t    CMD_PSALS_AUTO;
    /// PARAMETERS
    static const uint8_t    PARAM_I2C_ADDR;
    static const uint8_t    PARAM_CHLIST;
    static const uint8_t    PARAM_PSLED12_SELECT;
    static const uint8_t    PARAM_PSLED3_SELECT;
    static const uint8_t    PARAM_FILTER_EN;
    static const uint8_t    PARAM_PS_ENCODING;
    static const uint8_t    PARAM_ALS_ENCODING;
    static const uint8_t    PARAM_PS1_ADC_MUX;
    static const uint8_t    PARAM_PS2_ADC_MUX;
    static const uint8_t    PARAM_PS3_ADC_MUX;
    static const uint8_t    PARAM_PS_ADC_COUNTER;
    static const uint8_t    PARAM_PS_ADC_CLKDIV;
    static const uint8_t    PARAM_PS_ADC_GAIN;
    static const uint8_t    PARAM_PS_ADC_MISC;
    static const uint8_t    PARAM_VIS_ADC_MUX;
    static const uint8_t    PARAM_IR_ADC_MUX;
    static const uint8_t    PARAM_AUX_ADC_MUX;
    static const uint8_t    PARAM_ALSVIS_ADC_COUNTER;
    static const uint8_t    PARAM_ALSVIS_ADC_CLKDIV;
    static const uint8_t    PARAM_ALSVIS_ADC_GAIN;
    static const uint8_t    PARAM_ALSVIS_ADC_MISC;
    static const uint8_t    PARAM_ALS_HYST;
    static const uint8_t    PARAM_PS_HYST;
    static const uint8_t    PARAM_PS_HISTORY;
    static const uint8_t    PARAM_ALS_HISTORY;
    static const uint8_t    PARAM_ADC_OFFSET;
    static const uint8_t    PARAM_SLEEP_CTRL;
    static const uint8_t    PARAM_LED_RECOVERY;
    static const uint8_t    PARAM_ALSIR_ADC_COUNTER;
    static const uint8_t    PARAM_ALSIR_ADC_CLKDIV;
    static const uint8_t    PARAM_ALSIR_ADC_GAIN;
    static const uint8_t    PARAM_ALSIR_ADC_MISC;

    /// Response register
    static const uint8_t    RES_NO_ERROR;
    static const uint8_t    RES_INVALID_SETTING;
    static const uint8_t    RES_PS1_ADC_OVERFLOW;
    static const uint8_t    RES_PS2_ADC_OVERFLOW;
    static const uint8_t    RES_PS3_ADC_OVERFLOW;
    static const uint8_t    RES_ALS_VIS_ADC_OVERFLOW;
    static const uint8_t    RES_ALS_IR_ADC_OVERFLOW;
    static const uint8_t    RES_AUX_ADC_OVERFLOW;
    
    /// I2C Registers
    static const uint8_t    REG_PART_ID;
    static const uint8_t    REG_REV_ID;
    static const uint8_t    REG_SEQ_ID;
    static const uint8_t    REG_INT_CFG;
    static const uint8_t    REG_IRQ_ENABLE;
    static const uint8_t    REG_IRQ_MODE1;
    static const uint8_t    REG_IRQ_MODE2;
    static const uint8_t    REG_HW_KEY;
    static const uint8_t    REG_MEAS_RATE;
    static const uint8_t    REG_ALS_RATE;
    static const uint8_t    REG_PS_RATE;
    static const uint8_t    REG_ALS_LO_TH_LSB;
    static const uint8_t    REG_ALS_LO_TH_MSB;
    static const uint8_t    REG_ALS_HI_TH_LSB;
    static const uint8_t    REG_ALS_HI_TH_MSB;
    static const uint8_t    REG_PS_LED21;
    static const uint8_t    REG_PS_LED3;
    static const uint8_t    REG_PS1_TH_LSB;
    static const uint8_t    REG_PS1_TH_MSB;
    static const uint8_t    REG_PS2_TH_LSB;
    static const uint8_t    REG_PS2_TH_MSB;
    static const uint8_t    REG_PS3_TH_LSB;
    static const uint8_t    REG_PS3_TH_MSB;
    static const uint8_t    REG_PARAM_WR;
    static const uint8_t    REG_COMMAND;
    static const uint8_t    REG_RESPONSE;
    static const uint8_t    REG_IRQ_STATUS;
    static const uint8_t    REG_ALS_VIS_DATA0;
    static const uint8_t    REG_ALS_VIS_DATA1;
    static const uint8_t    REG_ALS_IR_DATA0;
    static const uint8_t    REG_ALS_IR_DATA1;
    static const uint8_t    REG_PS1_DATA0;
    static const uint8_t    REG_PS1_DATA1;
    static const uint8_t    REG_PS2_DATA0;
    static const uint8_t    REG_PS2_DATA1;
    static const uint8_t    REG_PS3_DATA0;
    static const uint8_t    REG_PS3_DATA1;
    static const uint8_t    REG_AUX_DATA0;
    static const uint8_t    REG_AUX_DATA1;
    static const uint8_t    REG_PARAM_RD;
    static const uint8_t    REG_CHIP_STAT;
    static const uint8_t    REG_UCOEF0;
    static const uint8_t    REG_UCOEF1;
    static const uint8_t    REG_UCOEF2;
    static const uint8_t    REG_UCOEF3;
    static const uint8_t    REG_MEAS_RATE_LSB;
    static const uint8_t    REG_MEAS_RATE_MSB;
    
    /// Values
    static const uint8_t    VAL_HW_KEY;
    static const uint8_t    VAL_UCOEF0;
    static const uint8_t    VAL_UCOEF1;
    static const uint8_t    VAL_UCOEF2;
    static const uint8_t    VAL_UCOEF3;
    static const uint8_t    VAL_INTOE;
    static const uint8_t    VAL_INTMODE;
    static const uint8_t    VAL_EN_ALS_VIS;
    static const uint8_t    VAL_EN_ALS_IR;
    static const uint8_t    VAL_EN_AUX;
    static const uint8_t    VAL_EN_UV;
    
    
    struct calib_t {
        uint32_t vispd_correction;
        uint32_t irpd_correction;
        uint32_t adcrange_ratio;
        uint32_t irsize_ratio;
        uint32_t ledi_ratio;        
        const uint8_t* ucoef;
    } m_calib;
    
    
public:
    
    enum illum_t {
        ILLUM_SUNLIGHT = 0,     // Sunlight
        ILLUM_INCANDESCENT = 1, // 2500K incandescent light bulb
        ILLUM_FLUORESCENT = 2,  // "Cool white" fluorescent light
    };
    enum gain_t {
        GAIN_0  = 0,
        GAIN_1  = 1,
        GAIN_2  = 2,
        GAIN_3  = 3,
        GAIN_4  = 4,
        GAIN_5  = 5,
        GAIN_6  = 6,
        GAIN_7  = 7
    };
    enum range_t {
        RANGE_LOW = 0,
        RANGE_HIGH= 1,
    };
    enum mode_t {
        MODE_SLEEP,
        MODE_FORCED,
        MODE_AUTO
    };
    
                        SI114x(void);
                        ~SI114x(void);  
    bool                init(I2C& i2c, uint8_t address=0x60);
    bool                start(const illum_t& ill=ILLUM_SUNLIGHT,
                              const range_t& visrange= RANGE_HIGH, const gain_t& visgain=GAIN_0,
                              const range_t& irrange = RANGE_HIGH, const gain_t&  irgain =GAIN_0,
                              const mode_t& mode = MODE_AUTO, float meas_delay = 1.0f, DigitalIn IRQ_PIN=NC);
    bool                stop(void);
    bool                done(void);
    bool                get(float& uv_index, float& visible, float& ir);
    bool                get(uint16_t& uv_index, uint16_t& visible, uint16_t& ir,bool update=true);
    
    const bool&         is_ok(void) const;
    const std::string&  name(void) const;
    
    
    // LOW LEVEL API
    bool            wait_until_sleep(void);
    bool            reset(void);
    bool            command(uint8_t cmd, uint8_t* response=NULL);
    bool            nop(void);
    bool            ps_force(void);
    bool            als_force(void);
    bool            ps_als_force(void);
    bool            ps_als_auto(void);
    bool            als_auto(void);
    bool            read_param(uint8_t& result, uint8_t param);
    bool            write_param(uint8_t param, uint8_t val, uint8_t* response=NULL);
    bool            ps_als_pause(void);
    bool            pause_all(void);
    uint16_t        uncompress(uint8_t input);
    uint8_t         compress(uint16_t input);
    bool            setInterrupt(bool enable);
    bool            getInterrupt(bool& enable);
    
    bool            read8(uint8_t& val, uint8_t reg);
    bool            read16(uint16_t& val, uint8_t reg);
    bool            write8(uint8_t reg, uint8_t val);
    bool            burst_read(uint8_t* data, uint8_t size, uint8_t reg);
    bool            burst_write(uint8_t reg, uint8_t* data, uint8_t size);
    const calib_t&  calib(void) const;
      
    uint8_t         part_id(void);  // returns 0x45 for 1145, 0x46 for 1146, 0x47 for 1147, 0xFF on failure
    uint8_t         rev_id(void);   // expected to return 0x00, 0xFF on failure
    uint8_t         seq_id(void);   // expected to return 0x08, 0xFF on failure

    bool            x_write8(uint8_t reg, uint8_t val);
    bool            x_read8(uint8_t& val, uint8_t reg);
    bool            x_command(uint8_t cmd, uint8_t* response=NULL);
    bool            x_write_param(uint8_t param, uint8_t val, uint8_t* response=NULL);
    
protected:
    I2C*            m_pI2C;
    uint8_t         m_address;
    bool            m_bOk;
    std::string     m_name;
    uint8_t         m_part_id;
    float           m_vis_norm;
    float           m_ir_norm;
    float           m_uv_norm;
    mode_t          m_mode;
    gain_t          m_visgain;
    gain_t          m_irgain;
    illum_t         m_illum;
    range_t         m_visrange;
    range_t         m_irrange;
    static float    m_norm_tab[2][8];
    
    bool            update_ranges(uint16_t vis, uint16_t ir);
    bool            set_vis_param(void);
    bool            set_ir_param(void);
    
    // Calibration code
    static const uint32_t   fx20_bad_value;
    static const uint32_t   fx20_one;
    static uint32_t         flt_to_fx20(float x);
    static void             fx20_round(uint32_t& value, int8_t bits=16);
    static uint32_t         fx20_div(uint32_t op1, uint32_t op2);
    static uint32_t         fx20_mul(uint32_t op1, uint32_t op2);
    
    
    static uint32_t         decode(uint32_t input);
    static uint32_t         collect(uint8_t* buffer, uint8_t msb_addr, uint8_t lsb_addr, uint8_t align);
    static void             shift_left(uint32_t& value, int8_t shift);
    static int8_t           align(uint32_t& value, int8_t dir);
    static const int8_t     align_left;
    static const int8_t     align_right;
    bool                    read_calibration(void);
    bool                    get_calibration_index(uint8_t* buffer);
    int16_t                 cal_index(uint8_t* buffer);
    uint32_t                _SIRPD_ADCHI_IRLED(uint8_t* buffer);
    uint32_t                _SIRPD_ADCLO_IRLED(uint8_t* buffer);
    uint32_t                _SIRPD_ADCLO_WHLED(uint8_t* buffer);
    uint32_t                _VISPD_ADCHI_WHLED(uint8_t* buffer);
    uint32_t                _VISPD_ADCLO_WHLED(uint8_t* buffer);
    uint32_t                _LIRPD_ADCHI_IRLED(uint8_t* buffer);
    uint32_t                _LED_DRV65(uint8_t* buffer);    
    bool                    set_ucoef(uint8_t* ucoef);
    uint32_t                vispd_correction(uint8_t* buffer);
    uint32_t                irpd_correction(uint8_t* buffer);
    uint32_t                adcrange_ratio(uint8_t* buffer);
    uint32_t                irsize_ratio(uint8_t* buffer);
    uint32_t                ledi_ratio(uint8_t* buffer);
    
    
    
    struct refcalib_t {
        uint32_t sirpd_adchi_irled;
        uint32_t sirpd_adclo_irled;
        uint32_t sirpd_adclo_whled;
        uint32_t vispd_adchi_whled;
        uint32_t vispd_adclo_whled;
        uint32_t lirpd_adchi_irled;
        uint32_t ledi_65ma;
        uint8_t  ucoef[4];        
    };
    
    static const refcalib_t m_refcalib[2];       
    
private:
    // No copy constructor for you!
    SI114x(const SI114x& other);
};

#endif
