#include "mbed.h"
#include "EaEpaper.h"
#include "SDFileSystem.h"
#include "tsi_sensor.h"
#include "img0.h"

#include <string>
#include <vector>

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif

EaEpaper epaper(PTD7,            // PWR_CTRL
                PTD6,            // BORDER
                PTE31,           // DISCHARGE
                PTA17,           // RESET_DISP
                PTA16,           // BUSY
                PTC17,           // SSEL
                PTD4,            // PWM
                PTD2,PTD3,PTD1,  // MOSI,MISO,SCLK
//                PTE0,PTE1);      // SDA,SDL 
                PTC11,PTC10);      // SDA,SDL 

//SDFileSystem(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name);
SDFileSystem sd(PTE1, PTE3, PTE2, PTE4, "sd" );
 
//Serial pc(USBTX,USBRX);

vector<string> filenames; //filenames are stored in a vector string

extern uint8_t _newImage[EA_IMG_BUF_SZ];

Bitmap bitmARM0 = {
  264, // XSize
  176, // YSize 
  33,  // Bytes in Line
  (char*)img0_bits // Pointer to picture data 
};

char img_bits[5808];
Bitmap bitmIMG0 = {
  264, // XSize
  176, // YSize 
  33,  // Bytes in Line
  img_bits // Pointer to picture data 
};

void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
  //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
    closedir(dp);
}

int read_filedata(char* fname)
{
    char buf[128];
    char sbuf[10];
    int line_idx, idx, len, i,j;
    uint8_t val;
    
    int ret = 0;
    
//    strcpy(path, "/sd");
//    strcat(path, fname);

//    pc.printf("PATH = %s\n", path);

    FILE *fp = fopen(fname, "r");
    if(fp == NULL)
    {
//        pc.printf("Could not open file for write\n");
        ret = 1;
        return ret;
    }
    
    line_idx = 0; 
    idx = 0;

//    while( fgets(buf, sizeof(buf), fp) != NULL )
    for(j=0;j<484;j++)
    {
        fgets(buf, sizeof(buf), fp);
        line_idx++;
        
 //       pc.printf("line=%d:%s", line_idx, buf);
        
        if(line_idx == 1)
        {
            if(strstr(buf,"264") == NULL )
            {
                ret = 1;
                break;
            }
        }
        if(line_idx == 2)
        {
            if(strstr(buf,"176") == NULL )
            {
                ret = 1;
                break;
            }
        }
        if(line_idx == 3)
        {
            continue;
        }
        
        len = strlen(buf);
        
        for(i=0;i<len;i++)
        {
            if(buf[i] == ',')
            {
                strncpy(sbuf, &buf[i-4], 4);
                /* 型変換 */
                sscanf(sbuf, "%x", &val);
                img_bits[idx] = val;
                idx++;
//                i=i+4;
            }
            else if(buf[i] == '}')
            {
                strncpy(sbuf, &buf[i-5], 4);
                /* 型変換 */
                sscanf(sbuf, "%x", &val);
                img_bits[idx] = val;
                idx++;
            }
            else if(buf[i] == 0x0D)
            {
                break;
            }
        }
    }

    fclose(fp); 

    return ret;
}
 
int main() 
{
    char str1[17];
    int i;

//    pc.printf("\nHello World!\n");

    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

    epaper.cls();
 
    // read file names into vector of strings
    //read_file_names("/sd");
  
    while (true) 
    {
        float w;
        int cnt;
        int stop_flag = 0;

        for(i=0;i<1000;i++)
        {
            if(i==0)
            {
                epaper.print_bm(bitmARM0, 1, 1);
                epaper.write_disp(); // update screen
                wait(0.1);
            }
            else
            {
                sprintf(str1,"%d",i);   
                char idir[14] = "/sd/";
                char dir[100] = "";
                strcat(dir,idir);
                strcat(dir,"/");
                strcat(dir,str1);
                strcat(dir,".xbm");
//                dir[4] = 0x30 + i;
//                if(read_filedata("/sd/1.xbm")== 0)
                if(read_filedata(dir)== 0)
                {
                    epaper.print_bm(bitmIMG0, 1, 1);
                    epaper.write_disp(); // update screen
                }
                else
                {
                    continue;
                }       
                cnt = 0;
                while (true) 
                {
                    w = tsi.readPercentage();
                    if(w > 0.8)
                    {
                        stop_flag = 1;
                        break;
                    }
                    else if(w > 0.3)
                    {
                        break;
                    }
                    cnt++;
                    if(cnt > 100)
                    {
                        break;
                    }
                    wait(0.1);
                }
//                epaper.cls();
                if(stop_flag == 1)
                {
                    break;
                }
            }
        }            
    }
}
