#include "mbed.h"
 
//are these actually used ??? - not used sg. Was for the inital LED's you had. Then I thought of the 4 into 16 while coding
DigitalOut ext_led[8] = {p21,p22,p23,p24,p25,p26,p27,p28};
//DigitalOut int_led[4] = {LED1, LED2, LED3, LED4};

// from handbook for BusOut:  Flexible way to write multiple DigitalOut pins as one value
BusOut int_led(LED1, LED2, LED3, LED4);  //four built-in LEDs used to display the counter from the trigger
 
//original from Sam in Seaside
//DigitalInOut fire(p20);     //connected to the tip of 2.5mm connector (T2i)
//DigitalInOut pre_fire(p19); //connected to the mid-connection for 2.5mm connector (T2i)

//modification to connect to the IMU carrier board
DigitalInOut fire(p29);     //connected to the tip of 2.5mm connector (T2i)
DigitalInOut pre_fire(p30); //connected to the mid-connection for 2.5mm connector (T2i)

// using ADIS hardware
//DigitalInOut fire(p29);     //connected to the tip of 2.5mm connector (T2i)
//DigitalInOut pre_fire(p30); //connected to the mid-connection for 2.5mm connector (T2i)

InterruptIn x(p18); 
Serial pc(USBTX, USBRX);


#define US_INTERVAL 500
    
//set the resolution of the timing information
#define MS_INTERVAL 2   //interval used to change the counter display 
 
void resetLed()
{
    for(int i=0; i<8; i++)
    {
        ext_led[i] = 0;
    }
    int_led = 0;
}

//xFire procedure is not used in the logic in main. This was to test the accuracy of the hotshoe trigger and it was spot on sg
void xFire()
{
    for(int i=1; i<16; i++)
    {
        wait_us(US_INTERVAL);
        int_led = i;
    }
    return;
}

volatile bool trigger = 0;
Ticker trig;
void setTrig()
{
    trigger = 1;
}
 
int main()
{
    // try open drain driving (internal pullup in camera?)
    //x procedure not used below 
    x.mode(PullUp);
    x.fall(&xFire);   
    
    fire.output();  //set the fire pin as outoput
    pre_fire.output();  //set the pre-fire pin as output
    //fire.mode(OpenDrain);
    
    //set up for the first trigger
    fire = 1;
    pre_fire = 1;
    
    // reset the LED's
    resetLed();
    
    //trig is a ticker used to repeatedly fire a trigger at the interval (e.g., 7.5 secs)
    trig.attach(&setTrig, 7.5f);  //set ticker interval to 7.5secs
    
    // start the program
    while(1)
    {
//        if(pc.readable())  //used to trigger from a keyboard click
//        {
//            char ch = pc.getc();  //read the keyboard click

          //below used for repeatedly triggering on a ticker
          if(trigger)  //is the ticker has fired the trigger, proceed ...
          {
            trigger = 0;  //reset the trigger to zero
            
            // turn all leds off to start the counter
            resetLed();
            
            // pre-fire the trigger using the mid-body 2.5mm connection (T2i)
            pre_fire = 0;
            
            wait(.25f);  //wait for 0.25 secs
            
            fire = 0; //fire the trigger using the tip connection
            
            wait(0.100f); // empirically known delay to get us to the range of the 4 timing LEDs 
            
            // maybe we need more or later just use these...
            //just count up to 16 diaplaying the results on the LEDs
            for(int i=1; i<16; i++)
            {
                wait_ms(MS_INTERVAL);
                int_led = i;  //write to the BusOut to display the counter on 4 LEDs
            }
            
            //reset for the next trigger
            // release the trigger
            fire = 1;
            pre_fire = 1;
        }
    }
}
