#include "crc.h"

//GPS-specific pins
DigitalOut GPS_Reset(p18);      //GPS RESET line
InterruptIn PPSInt(p15);        // GPS 1PPS (timemark) from the OEM615
InterruptIn IMUClock(p17);

Timer timeFromPPS;
unsigned long GPSTimemsecs = 0;

//mbed tx/rx interface to the GPS COM1 port
MODSERIAL GPS_COM1(p9,p10);  //this serial port communicates with the GPS receiver serial port (COM1)

bool loadingMessageBuffer = false;

const unsigned short maxGPSbytesPerSec = 2048;

int messagePerSecCounter = 0;
char msgBuffer0[2048];  //array to contain one full second of GPS bytes
char msgBuffer1[512];  //array to contain one full second of GPS bytes
char msgBuffer2[512];  //array to contain one full second of GPS bytes
int GPSbyteCounter0 = 0;
int GPSbyteCounter1 = 0;
int GPSbyteCounter2 = 0;
bool message0Complete = false;
bool message1Complete = false;
bool message2Complete = false;

////////////////////////////////////////////////////////////
//hotstart procedure
////////////////////////////////////////////////////////////
// Novatel OEM615 startup messages:
//   setapproxtime 1605 425384       // GPSWeek & GPSSeconds
//   setapproxpos 51.116 -114.038 0  //lat, lon, alt
////////////////////////////////////////////////////////////
//  how to use?
//  Assumes a certain power-up sequence: WALDO_FCS must be running on the PC??
//  unlikely this start-up sequence will work!!
//  PC MAY generates a startUp message that is checked for before the GPS RX starts
//  mbed looks for the startup message for 1 sec.
//  startUp message contains: Last PCTime, lastLat, lastLon, LastAlt, LastGPSWeek, LastGPSSeconds
//  If it is found, send the startup messages to the receiver
//  if it is not found, then just start without the messages (cold start)
//  On the PC side, check for a startUp file stored within the .exe folder.
//  However, if the PC clock time between now and the lastStart is > 24 hours, ignore startup file
//  if the startUp file IS PRESENT, use it to send the startUp message
//  After reading the startUp file on the PC, always delete it.
//  Every time the system enters "FINESTEERING", save the StartUp file

void sendASCII(char* ASCI_message, int numChars)
{
    /////////////////////////////////////////////////
    //send an ASCII command to the GPS receiver
    /////////////////////////////////////////////////

    //char ASCI_message[] = "unlogall COM1";
    int as = numChars - 1;
    unsigned char CR = 0x0d;  //ASCII Carriage Return
    unsigned char LF = 0x0a;  //ASCII Line Feed
    
    //printf("%s", ch);
    //printf("\n");

    for (int i=0; i<as; i++) GPS_COM1.putc(ASCI_message[i]); 
    GPS_COM1.putc(CR);   //carriage return at end
    GPS_COM1.putc(LF);   //line feed at end
};


//see the mbed COOKBOOK for MODSERIAL
//MODSERIAL is an easy to use library that extends Serial to add fully buffered input and output.
void readSerialByte(MODSERIAL_IRQ_INFO *q)
{ 
    MODSERIAL *serial = q->serial;      //see example of MODSERIAL usage in cookbook
    unsigned char synch0 = serial->getc();  //get the next byte
    
    totalGPSBytes++;

    //all OEM615 GPS ASCII messages begin with the unique character: "#"
    //read til we get a "#" and then start storing the message
    if (synch0 == '#')
    {
        if     (messagePerSecCounter == 0)  GPSbyteCounter0 = 0;
        else if(messagePerSecCounter == 1)  GPSbyteCounter1 = 0;
        else if(messagePerSecCounter == 2)  GPSbyteCounter2 = 0;
        //loadingMessageBuffer = true;
    }

    if     (messagePerSecCounter == 0)  { msgBuffer0[GPSbyteCounter0 % 1024] = synch0; GPSbyteCounter0++; }
    else if(messagePerSecCounter == 1)  { msgBuffer1[GPSbyteCounter1 % 512]  = synch0; GPSbyteCounter1++; }
    else if(messagePerSecCounter == 2)  { msgBuffer2[GPSbyteCounter2 % 512]  = synch0; GPSbyteCounter2++; }
    
    //stop storing the message when we get a LF
    if (synch0 == 0x0a /* LF*/)   //test for line feed
    {
        //as further confirmation, we could test the prior byte for a CR = 0x0d;
        
        if     (messagePerSecCounter == 0)  
        { 
            if ( msgBuffer0[GPSbyteCounter0 - 2] == 0x0d) //ensure the two byte end of message
                message0Complete = true;
        }
        else if(messagePerSecCounter == 1)  
        {
            if ( msgBuffer0[GPSbyteCounter0 - 2] == 0x0d) //ensure the two byte end of message
                message1Complete = true;
            }
        else if(messagePerSecCounter == 2)  
        {
            if ( msgBuffer0[GPSbyteCounter0 - 2] == 0x0d) //ensure the two byte end of message
                message2Complete = true;
        }
        messagePerSecCounter++;        //count the messages per second
    }
    
    //how this can fail??
    //  1) get noisy # occurrences (unique starting character)
    //  2) get noisy LF occurrences (unique ending character)
    //  3) get noisy data packet values or extra values
    //  4) we will also need to vet the data on the PC side
    //  5) here, we should do minimal testing and just pass the data as is 
    
};

