//these are defines for the messages that are sent from the PC across the USB
//these messages produce reactions on the mbed
//currently there is only a single message -- the trigger command
const unsigned char  FIRE_TRIGGER_MSG   = 1;

const unsigned short msgBuffSize = 28;
char messageBuffer[msgBuffSize+1];  //the +1 allows for a null-terminated string

//flags to control the mbed actions (in main) in response to the PC command
bool fireTrigger    = false;

unsigned char CR = 0x0d;                //ASCII Carriage Return
unsigned char LF = 0x0a;                //ASCII Line Feed

int totalNumChars = 0;

bool validMessage = false;

/*
void readFromPC()
{
    //read all available PC serial bytes and test the sequence for a command string
    if (toPC.readable()) 
    {   loopsThroughPCreadable++;  //reset to zero when we detect a valid message
        //wait_ms(5);
    }
    while (toPC.readable()) 
    {
        ///////////////////////////////////////////////////////////////////////////////////
        //PC-to-mbed and mbed-to-PC message format
        //   1) preamble:            "mbedmessage "   (note the space)
        //   2) messageType          "trig "          (note the space
        //   3) 10-char dataValue    "0000000000"     (ASCI integer representation
        //0123456789012345678901234567890123456789
        //mbedmessage trig 0000000000 CR/LF
        ///////////////////////////////////////////////////////////////////////////////////
        
        // Read in next character
        // we get through the main loop at > 500,000 times a sec
        unsigned char inChar = 0;
        inChar = toPC.getc();  //read char from the USB serial link to the PC
        
        totalNumChars++;
        
        //slide all the characters back by one place -- oldest char in the buffer gets discarded
        for (int i=0; i<(msgBuffSize-1); i++) messageBuffer[i] = messageBuffer[i+1];
        //now fill in the last entry to the buffer with the most recent received char
        messageBuffer[msgBuffSize-1] = inChar;
        
        //locate the proper message signature in the saved buffer:  "mbedmessage "
        if      (messageBuffer[0]  != 'm') continue;
        else if( messageBuffer[1]  != 'b') continue;
        else if( messageBuffer[2]  != 'e') continue;
        else if( messageBuffer[3]  != 'd') continue;
        else if( messageBuffer[4]  != 'm') continue;
        else if( messageBuffer[5]  != 'e') continue;
        else if( messageBuffer[6]  != 's') continue;
        else if( messageBuffer[7]  != 's') continue;
        else if( messageBuffer[8]  != 'a') continue;       
        else if( messageBuffer[9]  != 'g') continue;  
        else if( messageBuffer[10] != 'e') continue;  
        else if( messageBuffer[11] != ' ') continue; 
        //else if( messageBuffer[28] != CR) return;  
        //else if( messageBuffer[29] != LF) return;
        
        //from testing: this always activates on inChar multiple of 28
        //if ( inChar == 0x0a ) toPC.printf("%d  LF received:   %s\n",totalNumChars, messageBuffer);
        
        //if we get here. we have the proper signature of an incoming message
        //now test for the message types
        
        //why do we do this??
        //messageBuffer[msgBuffSize]= '/0'; //make the message buffer a null-terminated ASCII string
        
        //if (toPC.writeable()) toPC.printf(messageBuffer);    
            
        if (    messageBuffer[12] == 't' && 
                messageBuffer[13] == 'r' && 
                messageBuffer[14] == 'i' && 
                messageBuffer[15] == 'g'    )
        {
            //we have detected a trigger command message: "trig"  
            //send back a response to this message
            if (toPC.writeable())
            {
                 toPC.printf("FromMbed  %s \n", messageBuffer);
                 toPC.printf("FromMbed   %d  %d  \n", loopsThroughPCreadable, totalNumChars);
            }
            fireTrigger = true;
            loopsThroughPCreadable = 0;
        }
        
    }  //end pc.readable
};
*/

void readFromPC()
{
        
    //if there is no chars to read -- just return;
    if (!toPC.readable()) return;
    
    totalNumChars = 0;
    
    if (toPC.writeable())
    {
        toPC.printf("FromMbed  testing for Trigger \n");
    }
    
    bool timeOutInRead = false;

    timeInMessageRead.reset();
    
    while (totalNumChars < 16) 
    {
        ///////////////////////////////////////////////////////////////////////////////////
        //PC-to-mbed and mbed-to-PC message format
        //   1) preamble:            "mbedmessage "   (note the space)
        //   2) messageType          "trig "          (note the space
        //   3) 10-char dataValue    "0000000000"     (ASCI integer representation
        //0123456789012345678901234567890123456789
        //mbedmessage trig 0000000000 CR/LF
        ///////////////////////////////////////////////////////////////////////////////////
        
        // we get through the main loop at > 500,000 times a sec

        if ( toPC.readable() )
        { 
            messageBuffer[totalNumChars] = toPC.getc();
            totalNumChars++;
        }
        
        if (timeInMessageRead.read_us() > 500)
        {
             timeOutInRead = true;
             break;
        }
    }
    
    messageBuffer[28] = '\0';  //make a null-terminated string
       
    if (timeOutInRead)
    {
        if (toPC.writeable())
        {
            toPC.printf("FromMbed TimeOut %s \n", messageBuffer);
        }
    }
    
 
        
    if      (messageBuffer[0]  == 'm' &&
             messageBuffer[1]  == 'b' &&
             messageBuffer[2]  == 'e' &&
             messageBuffer[3]  == 'd' &&
             messageBuffer[4]  == 'm' &&
             messageBuffer[5]  == 'e' &&
             messageBuffer[6]  == 's' &&
             messageBuffer[7]  == 's' &&
             messageBuffer[8]  == 'a' &&       
             messageBuffer[9]  == 'g' &&  
             messageBuffer[10] == 'e' &&  
             messageBuffer[11] == ' ' && 
             messageBuffer[12] == 't' && 
             messageBuffer[13] == 'r' && 
             messageBuffer[14] == 'i' && 
             messageBuffer[15] == 'g'    )
        {

            
            //we have detected a trigger command message: "trig"  
            //send back a response to this message
            if (toPC.writeable())
            {
                toPC.printf("FromMbed  %s %d\n", messageBuffer, timeInMessageRead.read_us());
            }
            
            for (int i=0; i<=msgBuffSize; i++) messageBuffer[i] = 0;
            fireTrigger = true;
        }
        else
        {
            toPC.printf("FromMbed badMsg  %s \n", messageBuffer);
            for (int i=0; i<=msgBuffSize; i++) messageBuffer[i] = 0;
        }
};

