


//set up the SPI on pins 5, 6, 7 to read from the ADIS16488
SPI spi(p5, p6, p7); // mosi (DIN), miso (DOUT), sclk (CLK)
DigitalOut ADIS_CS(p8);     //Chip Select for the ADIS SPI
InterruptIn ADIS_DR(p28);   //DataReady interrupt connected to DIO2 for ADIS
DigitalOut ADIS_RST(p20);   //ADIS reset pin

bool IMUDataReady = false;
int IMURecordCounter = 0;
//see Table 9 from page 11 of the ADIS16488 spec 
//see fig 15 of spec -- note the low byte of the regsiter word is always zero
// X_DELTANG_LOW, Y_DELTANG_LOW, X_DETANG_LOW, X_DELTVEL_LOW, Y_DELTVEL_LOW, Z_DELTVEL_LOW
unsigned short LOW_REGISTER[]  = {0x4000, 0x4400, 0x4800, 0x4C00, 0x5000, 0x5400};   
// X_DELTANG_HIGH, Y_DELTANG_HIGH, X_DETANG_HIGH, X_DELTVEL_HIGH, Y_DELTVEL_HIGH, Z_DELTVEL_HIGH
unsigned short HIGH_REGISTER[] = {0x4200, 0x4600, 0x4A00, 0x4E00, 0x5200, 0x5600}; 

unsigned long IMUtimeFrom1PPS = 0;
    
union WD { long dataWord; unsigned short pt[2];} wd;

#pragma pack(1)
struct IMUREC
{
    unsigned long synch;
    unsigned short msgID;
    unsigned long GPSTime;
    long dataWord[6];
    //  4 + 2 + 4 + 24 = 34
} imuRec;

void IMUDataReadyISR(void)
{   
    //IMUtimeFrom1PPS = timeFromPPS.read_us();
    IMUClockCounter++;
    IMUDataReady = true;
    return;
} 

void setupADIS(void)
{
    ADIS_DR.mode(PullDown);
    ADIS_RST = 0;
    
    //  set the IMU dataReady ISR
    ADIS_DR.rise(&IMUDataReadyISR);
    
    // Setup the mbed SPI for 16 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(16,3);
    spi.frequency(1000000);   
    
    ADIS_CS = 1;  //CS must be set high before it goes low cause the enable is the transition
    ADIS_RST = 1;
    wait(0.5);
    ADIS_CS = 0; //set the Chip select low to enable the IMU SPI access
    
    spi.write((int)0x8003);  //change to page 3
    
    //change the DECRATE to 98.4 Hz (this is also in page 3)
    //the 8 sets the high bit to 1 indicating a write to a register
    // The C abd D designate the registers for the DECRATE of Page 3
    // The 0x17 sets the rate to:  2460/(23+1) = 102.5Hz
    // The 0x18 sets the rate to:  2460/(24+1) =  98.4Hz
    spi.write((int)0x8C17);    //write high byte  (only page number can be written in a single byte)
    spi.write((int)0x8D00);    //write the low byte of DECRATE 
    
    //to set the GPS VARF clock as the input synch clock for the IMU
    //the high byte is CD indicating the synch is enabled on the rising edge of the input clock  
    //spi.write((int)0x86CD);    //write high byte to register 0x06
    //spi.write((int)0x8700);    //write the low byte of 00 to registed 0x07
    
    //change the page to 0 to get the data
    spi.write((int)0x8000);  //change to page 0
    
    toPC.printf(" setting the default values\n");
    
    //set the IMU synch and message ID
    imuRec.synch = 0x1C1244AA;  //same as the GPS synch words

    imuRec.msgID=111;  //IMU record ID
    
    toPC.printf(" finished setting the default values\n");

}
