#ifndef SI7021_H
#define SI7021_H

#include "mbed.h"

#define SI7021_ADDR 0x80
#define SI7021_CONTROL_BYTE 0x3A    //Reset settings (default values ok, no need to write)
#define SI7021_MEASURE_RH_HOLD_MASTER 0xE5
#define SI7021_MEASURE_RH_NO_HOLD_MASSTER 0xF5
#define SI7021_MEASURE_TEMPERATURE_HOLD_MASTER 0xE3
#define SI7021_MEASURE_TEMPERATURE_NO_HOLD_MASTER 0xF3
#define SI7021_READ_TEMPERATURE 0xE0
#define SI7021_RESET 0xFE
#define SI7021_WRITE_USER_REG1 0xE6
#define SI7021_READ_USER_REG1 0xE7
#define SI7021_READ_EID1_1 0xFA
#define SI7021_READ_EID1_2 0x0F
#define SI7021_READ_EID2_1 0xFC
#define SI7021_READ_EID2_2 0xC9
#define SI7021_READ_FW_REVISION_1 0x84
#define SI7021_READ_FW_REVISION_2 0xB8

class SI7021_I2C {

public:
    SI7021_I2C(PinName sda, PinName scl);

    float Measure_Temp(void);
    void Measure_Humidity_Temp(float *humidity, float *temperature);

private:
    float get_HumidityTemp(void);
    uint8_t readBytes(uint8_t *values, int8_t length, bool waitConversion); 
    I2C i2c_;
};

#endif
