#include "mbed.h"
//DAC
#include "MCP4725.h"
//RFID
#include "MFRC522.h"
//TFT
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial_9.h"
#include "Small_6.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#define M_PI           3.14159265358979323846
 //KL25Z Pins for MFRC522 SPI interface
 #define SPI_MOSI    PTC6
 #define SPI_MISO    PTC7
 #define SPI_SCLK    PTC5
 #define SPI_CS      PTC4
 // KL25Z Pin for MFRC522 reset
 #define MF_RESET    PTC3
 // KL25Z Pins for Debug UART port
 #define UART_RX     PTA1
 #define UART_TX     PTA2
 
 DigitalOut LedRed   (LED_RED);
 DigitalOut LedGreen (LED_GREEN);
//Create a TFT contructor
 SPI_TFT_ILI9341 TFT(PTD2,PTD3,PTD1,PTE31,PTA20,PTA17,"TFT");//mosi,miso,sclk,cs,reset,dc el reset va conectado a 3.3v
 //Create a MRFID contructor
 Serial     DebugUART(UART_TX, UART_RX);
 MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);
//Create an MCP4725 object at the default address (ADDRESS_0)
MCP4725 dac(PTC11, PTC10); //SDA,SCL PTC1
Serial pc(USBTX, USBRX); 
InterruptIn ISW1(D10);
int x=0; 
int count = 0;
   int h ; 
  uint8_t LecturaUID[4]; 
  uint8_t Usuario1[4] ={0xC3,0x43,0xC9,0x2}; //tarjeta
  uint8_t Usuario2[4] ={0x29,0x36,0xB8,0xC1};  //llavero
  
bool comparaUID(uint8_t lectura[], uint8_t usuario[]){
for(int8_t  i = 0; i < RfChip.uid.size; i++){
 if (lectura[i]!= usuario[i]){
     return (false);
     }
  else {  return (true);
  }
 } 
 }
 
 void interfaZ(){
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(10,130);
    TFT.printf("Usuario: ");
    TFT.locate(10,170);
    TFT.printf("Registro");
    TFT.locate(10,185);
    TFT.printf("UID: ");
    TFT.locate(10,210);
    TFT.printf("TYPE: ");
    }
void subsw1(){ // define la funcion de casos
TFT.cls(); 
x=x++;
if(x==4){
    x=0;
    }
    }
void sineWave(){
TFT.set_orientation(4); //orientación de la pantalla
//interfaZ(); 
//Generate a sine wave on the DAC
count++; 
 if(count == 1){
    for (float i =0.0f ; i <= (M_PI)*2;i+=0.1f){
        dac.write((sin(i)/2)+0.5f);
        float a =(sin(i)/2)+0.5; 
        float a1 =a*3.3; 
        float a2 =a*50;
        TFT.pixel((i*10)+80,50+(int)a2 ,Red);
        printf ("%3f\n",a1); 
        }
       }
       else{
    for (float i =0.0f ; i <= (M_PI)*2;i+=0.1f){
        dac.write((sin(i)/2)+0.5f);
        float a =(sin(i)/2)+0.5; 
        float a1 =a*3.3; 
        float a2 =a*50;
        printf ("%3f\n",a1); 
        }
           }
    }
void SawtoohtWave(){
// Generate a sawthoo wave on the DAC
    for(float i =0.0f ; i <= 1.0f;i+=0.01f){
        dac.write(i);
        float a1 =i*3.3; 
     //   TFT.pixel(i,100 + (int)a1 ,Red);
        printf ("%3f  \n",a1); 
       }  
    }
void InvertedSawtoohtWave(){
//inverted sawthoo wave
     for(float i =1.0f ; i >= 0.0f;i-=0.01f){
       dac.write(i);
        float a1 =i*3.3; 
     //   TFT.pixel(i,100 + (int)a1 ,Red);
        printf ("%3f\n",a1); 
       }   
    }
void TriangularWave(){
//Generate triangular wave 
    for(float i =0.0f ; i <= 1.0f;i+=0.01f){
       dac.write(i);
        float a1 =i*3.3; 
      //  printf ("Voltage; %3f  \n",a1); 
       }
    for(float i =1.0f ; i >= 0.0f;i-=0.01f){
       dac.write(i);
        float a1 =i*3.3; 
      //  printf ("Voltage; %3f  \n",a1); 
       }  
    }
    void signalChangue(){
        switch (x) {
         case 0:
         sineWave();
         break;   
         case 1:
         SawtoohtWave();
         break; 
         case 2:
         InvertedSawtoohtWave();
         break;   
         case 3:
         TriangularWave();
         break;   
            }
        }

int main(){

ISW1.mode(PullUp);   // Configure port to PullUp or PullDown
ISW1.fall(&subsw1);  //rise ;subida   fall:bajada    
    // Set debug UART speed
     DebugUART.baud(115200);
     pc.baud(9500);
    //limpia la pantalla. 
    TFT.cls();
  TFT.set_orientation(4); //orientación de la pantalla
     interfaZ(); 
    // Init. RC522 Chip
     RfChip.PCD_Init();
    //Try to open the MCP4725
    if (dac.open()) {
       // printf("Device detected!\n");
        //Wake up the DAC
        //NOTE: This might wake up other I2C devices as well!
        dac.wakeup();
        while (1) {
        signalChangue();
 //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     LedRed   = 1;
     LedGreen = 1;
 
     // Look for new cards
     if ( ! RfChip.PICC_IsNewCardPresent()){
   //    wait_ms(500);
       continue;
     }
 
     LedRed   = 0;
 
     // Select one of the cards
     if ( ! RfChip.PICC_ReadCardSerial())
     {
    //   wait_ms(500);
       continue;
     }
 
     LedRed   = 1;
     LedGreen = 0;
 
     // Print Card UID
     pc.printf("Card UID: ");
     h = RfChip.uid.size;
     for (uint8_t  i = 0; i < RfChip.uid.size; i++) //uint8_t  unsigned int
     {
       LecturaUID[i] = RfChip.uid.uidByte[i];
       DebugUART.printf(" %X01", RfChip.uid.uidByte[i]);
     }
    
     DebugUART.printf("\n\r tamano: %d ",h);
     pc.printf("\n\r");
     
     
     if (comparaUID(LecturaUID, Usuario1)){
     pc.printf("Bienvenido Usuario1");
         TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(170,130);
    TFT.printf("Usuario1");
     }
     else if (comparaUID(LecturaUID, Usuario2)){
     pc.printf("Bienvenido Usuario2");
    TFT.locate(170,130);
    TFT.printf("Usuario2");
     }
     else {
         pc.printf("User Unknown");
       TFT.locate(170,130);
       TFT.printf("User Unknown");
         }
     
     pc.printf("\n\r");
     // Print Card type
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
     pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    // wait_ms(250);
        }
    } else {
        error("Device not detected!\n");
    }
}
