#include "mbed.h"
#include "XBeeLib.h"
#include "NTPClient.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"

#define _SDENABLE 
#define _DBG


#define REMOTE_NODE_ADDR64_MSB  ((uint32_t)0x0013A200)
#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x40e82830)
//#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x40B8EBCE)

#define REMOTE_NODE_ADDR16      ((uint16_t)0xFFFF)
#define REMOTE_NODE_ADDR64      UINT64(REMOTE_NODE_ADDR64_MSB, REMOTE_NODE_ADDR64_LSB)


using namespace XBeeLib;

Serial pc(DEBUG_TX, DEBUG_RX);

DigitalOut LED(D6);
time_t cTime;
Ticker now;
time_t rtime;
unsigned long waterlog = 0;

enum dataType {
    REQTOTAL = 0,    
    SENDDATA
};


void ethInit();
int storeSDCard(uint8_t *data, uint16_t len);
static void receiveXbee(const RemoteXBee802& remote, bool broadcast, const uint8_t *const data, uint16_t len);
static void sendRemoteXbee(XBee802& xbee, const RemoteXBee802& RemoteDevice);
time_t getCurTime();







void ledBlink(int cnt, int delay_ms = 50){
    
    LED = 0;
    
    for(int i = 0; i < cnt; i++){
        LED = 1;
        wait_ms(delay_ms);
        LED = 0;
        wait_ms(delay_ms);
    }
}

static void sendRemoteXbee(XBee802& xbee, const RemoteXBee802& RemoteDevice)
{   
    char data[20] = {'\0'};
    sprintf(data, "init");
    
    const uint16_t data_len = strlen(data);
    printf("%s\n",data);
    const TxStatus txStatus = xbee.send_data(RemoteDevice, (const uint8_t *)data, data_len);

    if (txStatus == TxStatusSuccess)
        printf(">> Send_data_to_remote_node OK...  %s\r\n",data);
    else
        printf(">> send_data_to_remote_node failed with %d\r\n", (int)txStatus);
}


static void receiveXbee(const RemoteXBee802& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{
    char tmp[50] = {'\0'};
        
#ifdef _DBG

    if (remote.is_valid_addr16b()) {
        printf("\r\n>> Got a %s 16-bit RX packet [%04x], len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", remote.get_addr16(), len);
    } else {
        printf("\r\n>> Got a %s 64-bit RX packet [%08x:%08x], len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", remote.get_addr64(), len);
    }
#endif
    
    for (int i = 1; i < len; i++){
        printf("%c", data[i]);
        tmp[i - 1] = data[i];
    }
    printf("\r\n");
    
   // int val = atoi(tmp);
    //printf("%d",val);
    if(data[0] == SENDDATA + 48){
         storeSDCard((uint8_t*)(data + 1), len - 1); 
     }
    else if(data[0] == REQTOTAL + 48){  //plust ascii
   //     readSDCard();  
    //    sendRemoteXbee(xbee, remoteDevice64b, val);  
    }
    
}

void ethInit(){
    
    int phy_link;
    printf("Wait a second...\r\n");

    uint8_t mac_addr[6] = {0x00,0x08,0xDC,0x1C,0xA8,0x95}; 
    
    EthernetInterface eth;
//    eth.init(mac_addr,"222.98.173.194","255.255.255.0","222.98.173.254"); //Use DHCP
    eth.init(mac_addr);
    eth.connect();
    
     do{
        phy_link = eth.ethernet_link();
        printf("...");
        ledBlink(1);
        wait(2);
     }while(!phy_link);
     printf("\r\n");
  
    printf("IP Address is %s\r\n", eth.getIPAddress());

}
// copied from Real time bus arrival alarm by eric
time_t getCurTime(){

    // NTP initialize
    NTPClient ntp;

    printf("\r\nTrying to update time...\r\n");    


    if (ntp.setTime("211.233.40.78") == 0) 
    {
        printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        ctTime += 32400; // GMT+9/Seoul
        printf("Time is set to (GMT+9): %s\r\n", ctime(&ctTime));
        return ctTime;
    }
    else
    {
        printf("Error\r\n");
        return 0;
    }
    
    
}
int readSDCard(){
    

}

int storeSDCard(uint8_t *data, uint16_t len){
    char buffer[35];
    char storeString[50] = {'\0'};
    time_t ctTime = getCurTime();
    data[len] = '\0';
    strftime(buffer, 35, "%Y/%m/%d %I:%M %p", localtime(&ctTime));

    //printf("%s\n%s\n", buffer ,data);
    
    mkdir("/sd/WaterLogger", 0777);
    
    FILE *fp = fopen("/sd/WaterLogger/WarerLevel.txt", "a");
    if(fp == NULL) {
        error("Could not open file for write\n");
        return 0;
    }
    ledBlink(5);
    sprintf(storeString,"%s %sml\r\n", buffer, data);
    fprintf(fp, storeString);
    fclose(fp); 
    waterlog += atoi((char*)data);
    
#ifdef _DBG
    printf("%s",storeString);    
    printf("Stored Water Level\n");
#endif

    return 1;
}


//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
void addTime(){
    
    rtime++;
}


int main()
{
    
   // printf("%d",val);
    ethInit(); // ethernet initialiaze

    pc.baud(9600);
    
    XBee802 xbee = XBee802(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);
    SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // the pinout on the mbed Cool Components workshop board
    
    /* Register callback */
    xbee.register_receive_cb(&receiveXbee);
    RadioStatus const radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);
    const RemoteXBee802 remoteDevice64b = RemoteXBee802(REMOTE_NODE_ADDR64);  
    
    rtime = getCurTime();
    struct tm *realtime;
    realtime = localtime(&rtime);
    set_time(rtime);
    now.attach(&addTime, 1); //tick for realtime
    
    //strftime(buffer, 35, "%Y/%m/%d %I:%M %p", localtime(&rtime));    
    while (true) {
       // strftime(buffer, 35, "%Y/%m/%d %I:%M %p", localtime(&rtime));    
     //  strftime(buffer, 35, "%I:%M %p %S\n",localtime(&rtime));
       // printf("%s",buffer);
        
        //if( realtime->tm_hour == 0 && realtime->tm_min == 0 && realtime->tm_sec == 0)
           // sendRemoteXbee(xbee, remoteDevice64b);  
        
        xbee.process_rx_frames();
        wait_ms(100);
    }
    

}





