#include "mbed.h"
#include "rtos.h"
#include "TCPSocket.h"
#include "TCPServer.h"
#include "WizFi310Interface.h"


//#define SOFTAPMODE
//#define RUN_SERVER

#ifdef SOFTAPMODE
#define AP_SSID     "AP_SSID"
#define AP_PASSWORD "AP_PASSWORD"
#define AP_SECURITY NSAPI_SECURITY_WPA2
#else
#define AP_SSID     "AP_SSID"
#define AP_PASSWORD "AP_PASSWORD"
#define AP_SECURITY NSAPI_SECURITY_WPA2
#endif

//server ip, clinet mode
uint8_t ipaddr[4] = {192,168,1,194};
#define PORT 5000

Serial pc(USBTX,USBRX);
WizFi310Interface wifi(D8, D2, D7, D6, D9, NC, 115200);

char rx_buf[512] = {'\0',};

TCPServer server;
TCPSocket client;

int TryApUp();
int TryServerUpAndWaitClient();
int ClientExample();
int RunEcho();

typedef enum ConnectionStep { DISASSOCIATED = 1, ASSOCIATED, LISTENED, CONNECTED, DISCONNECTED } conStep;
conStep ConnectionStep = DISASSOCIATED;


void print_char(char c = '*')
{
    printf("%c", c);
    fflush(stdout);
}

DigitalOut led1(LED1);


void print_star(void const *argument)
{
    
    while (true) {
        Thread::wait(1000);
        print_char();
    }
}

void connection_thread(void const *arg)
{
    while(true){
    
        TryApUp();

#ifdef RUN_SERVER
        TryServerUpAndWaitClient();
#else
        ClientExample();
#endif

        RunEcho();
    }   
}

int main()
{
    pc.baud(115200);
    
    printf("\n\n*** Run WizFi310 on RTOS ***\r\n");
    Thread star_thread(print_star, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    Thread con_thread(connection_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    
    while (true) {
        led1 = !led1;
        Thread::wait(500);
    }
}



int TryApUp()
{    

    if( ConnectionStep == DISASSOCIATED){
        printf(" AP UP\r\n");
        printf("SSID: %s\r\nPASS: %s\r\n", AP_SSID, AP_PASSWORD);
        
        for(int i= 0; i<5; i++)
        {
#ifdef SOFTAPMODE
            if ( wifi.connectAP(AP_SSID, AP_PASSWORD, AP_SECURITY) < 0 )
#else
            if ( wifi.connect(AP_SSID, AP_PASSWORD, AP_SECURITY) < 0 )
#endif
                continue;
            else {
                const char *ip = wifi.get_ip_address();
                printf("my IP address is: %s\r\n", ip ? ip : "No IP");
                ConnectionStep = ASSOCIATED;
                return 0;        
            }
        }
        printf("Fail to make AP\r\n");
        ConnectionStep = DISASSOCIATED;
    }
    
    return -1;
}

int ClientExample()
{
    int ret = 0;
    if( ConnectionStep == ASSOCIATED )
    {
        SocketAddress addr((void*)ipaddr, NSAPI_IPv4, PORT);
        //SocketAddress addr(&wifi, "www.google.com", 80);
        
        printf("server IP address is: %s\r\n", addr.get_ip_address());
        
        

        client.set_timeout(1000);   // Set Block Mode.
        
        client.open(&wifi);

        if(client.connect(addr) < 0){
            printf("Connection fail\r\n");
        }
        else{
            printf("Connection Success!!\r\nIP: %s, %d\r\n", addr.get_ip_address(), addr.get_port());
            ConnectionStep = CONNECTED;
        }
 }   
}


int TryServerUpAndWaitClient()
{
    if( ConnectionStep == ASSOCIATED )
    {
        
        if( server.open(&wifi) < 0 )
        {
            printf("WiFi Binding fail..\r\n");
            return -1;
        }
        
            
        if( server.bind(wifi.get_ip_address(), PORT) < 0 )
        {
            printf("Bind fail..\r\n");
            return -1;
        }
        
        if( server.listen(0) < 0 )
        {
            printf("Listen fail..\r\n");
            return -1;
        } else {
            printf("Listen PORT: %d\r\n",PORT);    
            ConnectionStep = LISTENED;
        }
    }
    
    //server.set_blocking(true);
    
    while(ConnectionStep == LISTENED)
    {
        if( server.accept(&client) < 0 )
        {
            printf("accept fail..\r\n");
            return -1;
        }else{    
            printf("Connection Success!!\r\n");
            ConnectionStep = CONNECTED;
            return 0;
        }
    }
    
    return -1;
}

int RunEcho()
{
    int rcv_length = 0;
    if(ConnectionStep == CONNECTED)
    {
        memset(rx_buf, 0, sizeof(rx_buf));
        rcv_length = client.recv(rx_buf, sizeof(rx_buf));
        if(rcv_length > 0)
        {
            printf("RECV: %s\r\n", rx_buf);
            client.send(rx_buf, rcv_length);
        }
    }
}
