#include "mbed.h"
#include "WizFi250Interface.h"


/* AP Info */
#define SECURE WizFi250::SEC_WPA2_MIXED
#define SSID "WizFi250_AP_TEST"
#define PASS "1234567890"

/* Socket Info */
#define PORT 5000

Serial pc(USBTX, USBRX);

/* network setup */
WizFi250Interface wizfi250(P13,P14,P11,P12,P15,NC,115200);
TCPSocketServer server;
TCPSocketConnection client; 

/* functions */
int TryApUp();
int TryServerUp();
int WaitClient();
int ApDown();

/* variables */
int isListened = 0;

int main()
{   
    pc.baud(115200);
    pc.printf("Start Application AP TCP Server\r\n");
    
    
    if( TryApUp() < 0 ) return -1;
    
    if( TryServerUp() < 0 ) return -1;
    
    if( WaitClient() < 0 ) return -1;
    
    
    while( client.is_connected() )
    {
        int len = 0;
        char rcvBuf[1024] = {0,};
        
        if( wizfi250.readable(0) > 0 )
        {
            len = client.receive(rcvBuf, 1023);
            if( len > 0 )
            {
                client.send(rcvBuf, len);
            }
        }
    }
    
    
    pc.printf("End Application\r\n");
    return 0;
}



int TryApUp()
{
    
    if( wizfi250.isAssociated() == 1 ) return -1;
    
    isListened = 0;
    
    for(int i= 0; i<5; i++)
    {
        wizfi250.init();
        wizfi250.setAddress("192.168.0.2","255.255.255.0","192.168.0.2");
        if ( wizfi250.connect(SECURE, SSID, PASS, WizFi250::WM_AP) )
            continue;
        else
        {
            pc.printf("IP Address is %s\r\n", wizfi250.getIPAddress());
            return 0;
        }
    }

    printf("Fail to make AP\r\n");
    return -1;
}


int TryServerUp()
{
    if( wizfi250.isAssociated() != 1 ) return -1;

    if( server.bind(PORT) < 0 )
    {
        pc.printf("Bind fail..\r\n");
        return -1;
    }
    
    if( server.listen(1) < 0 )
    {
        pc.printf("Listen fail..\r\n");
        return -1;
    }
    
    pc.printf("Listen PORT: %d\r\n",PORT);
    isListened = 1;    
    return 0;
}

int WaitClient()
{
    
    while( isListened )
    {
        if( server.accept(client) < 0 )
        {
            pc.printf("accept fail..\r\n");
            return -1;
        }
        
        pc.printf("Connection Success!!\r\nIP: %s\r\n", client.get_address());
        return 0;
    }
    
    return -1;    
}