#include "mbed.h"
#include "WiFiTracker.h"
 
Serial wifi(P23, P24);

int8_t send_command(char*);
void init_tracker();
int tracking();

WiFiTracker tracker;

int main() {
    
    wifi.baud(9600);
    
    printf("Start Tracking...\n");   
    
    init_tracker();

    while(1)
    {
        tracking();         
    }   

}


// 0x4000/04:1b:ba:21:6d:a1/-66
int tracking()
{
    char buf[30] = {0,};
    int i=0;
    
    while(1)
    {
        if(wifi.readable())
        {
            buf[i++] = wifi.getc();
    
            if(strstr(buf,"\r\n"))
            {    
                tracker.write_sdcard(buf, i);
                return 0;
            }
        }
    }   
}


void init_tracker()
{
    
    //char cmd[] = "AT+MWPACKET=3,1,1,0,4000,,11010111";
    char cmd[] = "AT+MWPACKET=3,1,3,0,4000,,10010001";
    int8_t ret = -1;
    
    
    ret = send_command(cmd);
    printf("init ret: %d",ret);

    
}

int8_t send_command(char* cmd)
{
    int len = strlen(cmd);
    int i;
    
    for(i=0; i<len; i++)
        wifi.putc(cmd[i]);
       
    wifi.putc('\r');
    wifi.putc('\n');
    
    return 0;
}

//int8_t wait_response(char* rsp, uint32_t timeout)
//{
//    char buf[256] = {0,};
//    char c;
//    Timer t;
//    uint32_t time;
//    t.start();
//    
//    while(1)
//    {    
//        if(wifi.readable())
//            tracker.write(wifi.getc());
//        
//        //  수정해야 
//                
//    }
//}
