#include "RingBuffer.h"
#include "SDFileSystem.h"
#include "mbed.h"

typedef struct WiFiProbe
{    
    uint8_t mac[6];
    int8_t rssi;
    int8_t cnt;
    
}WiFiProbe;


class WiFiTracker
{
public:

    WiFiTracker() ;
    ~WiFiTracker();
    
    uint8_t write_sdcard(char c);
    uint8_t write_sdcard(char* str, int len);
    
    char read();
    int write(char);
    int find(char*);
    
    
    int char_cnt(char*, char);
    int char_change(char*, char, char);
    
    void LedBlink(int, int);
    
private:
    RingBuffer buffer;
    Serial dbg;
    SDFileSystem sd;
    FILE *fp;
    DigitalOut led;
    
    uint32_t g_store_cnt; 
    
};

