#include "mbed.h"
#include "WiFiTracker.h"



WiFiTracker::WiFiTracker() : dbg(USBTX, USBRX), sd(PB_3, PB_2, PB_1, PB_0, "sd"), led(LED3)
{
    
    buffer.init(128);
    printf("make wifi tracker!\n"); 
    g_store_cnt = 0;
    mkdir("/sd/mydir", 0777);
    
    LedBlink(5, 20);
    
}


WiFiTracker::~WiFiTracker()
{
    printf("destroy\n");
    fclose(fp);
}


//uint8_t WiFiTracker::store_probe_request(WiFiProbe wp)
//uint8_t WiFiTracker::store_probe_request(char c)
uint8_t WiFiTracker::write_sdcard(char c)
{
    dbg.printf("store\n"); 
    
    return 0;
}

uint8_t WiFiTracker::write_sdcard(char* str, int len)
{    
    char temp_str[30] = {0,};
    
    //dbg.printf("%s, (%d)", str, len);
    
    if(char_cnt(str,'/') && len == 30 )
    {
        strncpy(temp_str, str, len);
        char_change(temp_str, '/', ',');
        dbg.printf("(%d), %s", len, temp_str);
        fprintf(fp, temp_str);
        g_store_cnt++;  
    }
    
    
    if(g_store_cnt % 100 == 0)
    {
        dbg.printf("\r\n[100]\r\n");
        fclose(fp);
        
        fp = fopen("/sd/mydir/wifi_tracker.txt", "a");
        if(fp == NULL) {
            error("Could not open file for write\n");
        } 
        
        LedBlink(2,50);
    }
    
    //dbg.printf("\r\nwrite sd card\r\n"); 
    return 0;
}

char WiFiTracker::read()
{
    return (char)buffer.consumeByte();
}

int WiFiTracker::write(char c)
{
    //return buffer.addbyte((byte)c);
    return 0;

}

int WiFiTracker::find(char* str)
{
    return buffer.findBuf(str);
    
}



int WiFiTracker::char_cnt(char* str, char c)
{
    int i = 0;
    char* tmp = str;
    
    while( *tmp )
    {
        if( *tmp++ == c )
            i++;
    }
    
    return i;
}


int WiFiTracker::char_change(char* str, char dst_char, char new_char)
{
    int i = 0;
    char* tmp = str;
    
    while( *tmp )
    {
        if( *tmp == dst_char )
            *tmp = new_char;
        tmp++;
    }
    
    return i;    
    
} 

void WiFiTracker::LedBlink(int cnt, int interval)
{
    int i;
    
    for(i=0; i<cnt; i++)
    {
        led = 1;
        wait_ms(interval);
        led = 0;
    }
}

//
//int8_t WiFiTracker::send_command(char* cmd)
//{
//
//}
//int8_t WiFiTracker::wait_response(char* rsp)
//{
//}



