#include "mbed.h"


#define delimiter "/"
#define probe_filter "0x4000"

#define JUST_PRINT 1
#define MQTT_PUBLISH 2

struct WiFiProbe
{    
    char mac[18];
    //int rssi;
    char rssi[5];
    int8_t cnt;
    
};


class WiFiTracker
{
public:

    WiFiTracker() ;
    ~WiFiTracker();
    
    void init();
    
    int8_t send_command(char* cmd);
    int8_t tracking(int );
    
    int8_t getProbe(char* mac, char* rssi);
    
    
    uint8_t write_sdcard(char c);
    uint8_t write_sdcard(char* str, int len);
    
    
    
    
    bool isValidData(WiFiProbe*, char*);
    
    int char_cnt(char*, char);
    int char_change(char*, char, char);
    void delete_char(char *src, char c, int len);
    void LedBlink(int, int);
    
private:
    Serial wifi;
    DigitalOut led;
    WiFiProbe PreProbe;
    bool isPrinted;
    
    uint32_t g_store_cnt; 
    
};

