#include "mbed.h"
#include "WiFiTracker.h"



WiFiTracker::WiFiTracker() : led(LED3), wifi(P23, P24)
{
    wifi.baud(115200);
//    dbg.baud(115200);
    led = 0;
//    dbg.printf("make wifi tracker!\n"); 
    g_store_cnt = 0;
    isPrinted = false;
    //mkdir("/sd/mydir", 0777);
    
    LedBlink(5, 20);
    
}


WiFiTracker::~WiFiTracker()
{
    printf("destroy\n");

}


void WiFiTracker::init()
{

    //char cmd[] = "AT+MWPACKET=3,1,1,0,4000,,11010111";
    char cmd[] = "AT+MWPACKET=3,1,3,0,4000,,10010001";
    int8_t ret = -1;
    
    ret = send_command(cmd);
    printf("init ret: %d",ret);    
}

// 0x4000/04:1b:ba:21:6d:a1/-66
int8_t WiFiTracker::tracking(int method)
{
    char buf[30] = {0,};
    struct WiFiProbe probe;
    bool ret;
    
    if(wifi.readable())
    {
        wifi.scanf("%s",&buf);
        
        ret = isValidData(&probe, buf);
        
        if( ret == true )
        {
            if( !strcmp(PreProbe.mac, probe.mac) )
            {   
                isPrinted = true;
                //dbg.printf("non print mac (%s)\n",probe.mac);
                return -1;
            }
            else
            {
                memcpy(&PreProbe, &probe, sizeof(WiFiProbe));
                isPrinted = false;
                return 0;
            }
            
            //switch(method)
//            {
//                case MQTT_PUBLISH:
//                    
//                case JUST_PRINT:
//                    dbg.printf("(%s, %d)\n",probe.mac, probe.rssi);
//                    break;
//            }
        }
        else return -1;   
    }
    return 0;
}
bool WiFiTracker::isValidData(WiFiProbe* probe,char* str)
{
    char *p, *p1;
    char char_rssi[3] = {0,};
    
    p = strstr(str, probe_filter);
    
    if( p == NULL )
    {
        return false;
    }
    else
    {    
        memset(probe,'\0',sizeof(WiFiProbe));
        
        p = strstr(str, delimiter);
        p1 = strstr(p+1, delimiter);
        
        strncpy(probe->mac,p+1,(p1-p-1));
        
        delete_char(probe->mac,':',strlen(probe->mac));
        
        strcpy(probe->rssi, p1+2);
        
//        strcpy(char_rssi, p1+2);
//        probe->rssi = atoi(char_rssi);
        //dbg.printf("(%s, %d)\n",probe->mac, probe->rssi);
        return true;
    }
}

int8_t WiFiTracker::getProbe(char* mac, char* rssi)
{
    
    
    memcpy(mac, PreProbe.mac, sizeof(PreProbe.mac));   
    memcpy(rssi, PreProbe.rssi, sizeof(PreProbe.rssi));
    
    if( isPrinted )
        return -1;
    else
    {
        isPrinted = true;
        return 0;
    }
}

//uint8_t WiFiTracker::store_probe_request(WiFiProbe wp)
//uint8_t WiFiTracker::store_probe_request(char c)
uint8_t WiFiTracker::write_sdcard(char c)
{
//    dbg.printf("store\n"); 
    
    return 0;
}

uint8_t WiFiTracker::write_sdcard(char* str, int len)
{    
    char temp_str[30] = {0,};
    
    //dbg.printf("%s, (%d)", str, len);
    
    if(char_cnt(str,'/') && len == 30 )
    {
        strncpy(temp_str, str, len);
        char_change(temp_str, '/', ',');
//        dbg.printf("(%d), %s", len, temp_str);
        g_store_cnt++;  
    }
    
    
    if(g_store_cnt % 100 == 0)
    {
//        dbg.printf("\r\n[100]\r\n");
        
        LedBlink(2,50);
    }
    
    //dbg.printf("\r\nwrite sd card\r\n"); 
    return 0;
}


// count the number of c in str
int WiFiTracker::char_cnt(char* str, char c)
{
    int i = 0;
    char* tmp = str;
    
    while( *tmp )
    {
        if( *tmp++ == c )
            i++;
    }
    
    return i;
}

// change dst_char to new_char in str
int WiFiTracker::char_change(char* str, char dst_char, char new_char)
{
    int i = 0;
    char* tmp = str;
    
    while( *tmp )
    {
        if( *tmp == dst_char )
            *tmp = new_char;
        tmp++;
    }
    
    return i;    
    
} 


void WiFiTracker::delete_char(char *src, char c, int len)
{

    char *dst;

    int i;
    // Do not remove NULL characters.
    if ( c == 0 )
        return;
        
    // Small attempt to control a buffer overflow if the
    // the string is not null-terminated and a proper length
    // is not specified.

    if ( len <= 0 )
        len = 17;

    dst = src;

    for ( i = 0; i < len && *src != 0; i++, src++ )
    {
        if ( *src != c )
            *dst++ = *src;

    }
    // Ensure the string is null-terminated.

    *dst = 0;

    return;

}

// delete_char()

void WiFiTracker::LedBlink(int cnt, int interval)
{
    int i;
    
    for(i=0; i<cnt; i++)
    {
        led = 1;
        wait_ms(interval);
        led = 0;
    }
}


int8_t WiFiTracker::send_command(char* cmd)
{
    wifi.printf("%s\r",cmd);    
    return 0;
}

//int8_t WiFiTracker::wait_response(char* rsp)
//{
//}



