#include "mbed.h"
#include "XBeeLib.h"
#include "HX711.h"
#include "SeeedGrayOLED.h"  // Seeed Grove: OLED Display 0.96" 96x96

#define REMOTE_NODE_ADDR64_MSB  ((uint32_t)0x0013A200)
#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x40e8282a)
//#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x40B8EBCE)

#define REMOTE_NODE_ADDR16      ((uint16_t)0xFFFF)
#define REMOTE_NODE_ADDR64      UINT64(REMOTE_NODE_ADDR64_MSB, REMOTE_NODE_ADDR64_LSB)

////
#define BOTTLE_SAMPLE_RATE 10
#define MAX_WATER 2000 // 2L
unsigned int waterlog = 0;

////
enum dataType {
    REQTOTAL = 0,    
    SENDDATA
};

enum status {
    NEED_SET_DEFAULT = 0,
    SET_DEFAULT,
    CHECK_BOTTLE,
    SENSE_WATER_LEVEL,
    WAIT_INPUT
}; 


using namespace XBeeLib;

Serial pc(DEBUG_TX, DEBUG_RX);
HX711 gram(A1, A0, 64);
DigitalIn default_button(D7);
DigitalIn bottle_weight(D8);
DigitalOut LED(D6);
SeeedGrayOLED SeeedGrayOled(D14, D15);

void Draw_OLED_log(uint8_t val);
void OLED_Display(float val);


static void receiveXbee(const RemoteXBee802& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{
    char tmp[50] = {'\0'};
        
#ifdef _DBG

    if (remote.is_valid_addr16b()) {
        printf("\r\n>> Got a %s 16-bit RX packet [%04x], len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", remote.get_addr16(), len);
    } else {
        printf("\r\n>> Got a %s 64-bit RX packet [%08x:%08x], len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", remote.get_addr64(), len);
    }
#endif
    
    for (int i = 1; i < len; i++){
        printf("%c", data[i]);
        tmp[i - 1] = data[i];
    }
    printf("\r\n");
    
    if(!strncmp("init",(char*)data,len)){
        waterlog = 0;

    }
    
}
static void sendRemoteXbee(XBee802& xbee, const RemoteXBee802& RemoteDevice, uint8_t type ,long weight)
{   
    char data[20] = {'\0'};
    sprintf(data, "%1d%i\0",type, weight);
    
    const uint16_t data_len = strlen(data);
    
    const TxStatus txStatus = xbee.send_data(RemoteDevice, (const uint8_t *)data, data_len);

    if (txStatus == TxStatusSuccess)
        printf(">> Send_data_to_remote_node OK...  %s\r\n",data);
    else
        printf(">> send_data_to_remote_node failed with %d\r\n", (int)txStatus);
}

int checkWeight(){
    long sum = 0;
    
    for(int i = 0; i < BOTTLE_SAMPLE_RATE; i++){
        sum += gram.getGram();
        wait_ms(100);
    }
    
    return sum / BOTTLE_SAMPLE_RATE;
}


void ledBlink(int cnt, int delay_ms = 50){
    
    LED = 0;
    
    for(int i = 0; i < cnt; i++){
        LED = 1;
        wait_ms(delay_ms);
        LED = 0;
        wait_ms(delay_ms);
    }
}
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////
//////////////////////////////////////

int main()
{
    pc.baud(9600);
    
    XBee802 xbee = XBee802(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);
    
    
    /* Register callback */
    xbee.register_receive_cb(&receiveXbee);
    RadioStatus const radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);
    const RemoteXBee802 remoteDevice64b = RemoteXBee802(REMOTE_NODE_ADDR64);
    
    SeeedGrayOled.init();             // Initialize SEEED OLED display
    SeeedGrayOled.clearDisplay();     // Clear Display
    SeeedGrayOled.setNormalDisplay(); // Set Normal Display Mode
    
//    for(int i=0; i<2000; i+=100)
//        OLED_Display((float)i);
    OLED_Display(0);
    
    long Weight; //current weight
    long botWeight = 0; //bottle weight
    
    long WaterLevel = 0;
    long pWaterLevel = 0;
    long dWaterLevel = 0;
    uint8_t Status;

    Status = NEED_SET_DEFAULT;

    
    
    while (true) {
        if(!default_button)
            Status = SET_DEFAULT;
        else if(!bottle_weight)
            Status = CHECK_BOTTLE;
            
        switch(Status){
            case NEED_SET_DEFAULT:
//                   printf(">>> You need to set the default.\n>>>Press the SET KEY\n\n");
                     printf(".");
                     wait(1);
                break;
                
            case SET_DEFAULT:
                    gram.tare();
                    ledBlink(1, 100);
                    
                    printf(">>> Set the base weight\n");
                    Weight = 0;
                    botWeight = 0;
                    WaterLevel = 0;
                    pWaterLevel = 0;
                    
                    Status = WAIT_INPUT;
                break;
            
            case CHECK_BOTTLE:                        
                    pWaterLevel = 0;
                    botWeight = checkWeight();
                    printf(">>> Your Bottle is %i g\n", botWeight);
                    ledBlink(3);
                    Status = SENSE_WATER_LEVEL;

                break;
                    
            case SENSE_WATER_LEVEL:
            
                    Weight = checkWeight();
                    WaterLevel = Weight - botWeight;
                    printf("W: %i \t B: %i\n",WaterLevel,pWaterLevel);
                    
                    if(WaterLevel <= 10 && WaterLevel > -10)   // allowable error
                        break;
                    else if(WaterLevel <= -10){                // error
                        printf("WaterLevel: %i\n",WaterLevel);
                        //Status = NEED_SET_DEFAULT;
                        break;
                    }
                    
                    if(WaterLevel < (pWaterLevel*0.95)){
                        
                        wait(1);
                        long check_again = checkWeight();
                        if(check_again < (WaterLevel*0.98) || check_again > (WaterLevel*1.02))
                            break;
                        
                        dWaterLevel = pWaterLevel - WaterLevel; 
                        ledBlink(5);
                        waterlog += dWaterLevel;
                        OLED_Display((float)waterlog);
                        
                        sendRemoteXbee(xbee, remoteDevice64b, SENDDATA,dWaterLevel);
                        pWaterLevel = WaterLevel;
                    }
                    else if(WaterLevel > pWaterLevel){
                        wait(1);
                        long check_again = checkWeight();
                        if(check_again < (WaterLevel*0.98) || check_again > (WaterLevel*1.02))
                            break;
                        pWaterLevel = WaterLevel;     
                    }
                break;
            case WAIT_INPUT:
            default:
                break;
        }
    

        wait_ms(100);
    }
    

}


void OLED_Display(float val)
{
    
    if(val < MAX_WATER*0.03)
        Draw_OLED_log(0);
    else if(val < MAX_WATER*0.10)
        Draw_OLED_log(10);
    else if(val < MAX_WATER*0.30)
        Draw_OLED_log(30);
    else if(val < MAX_WATER*0.40)
        Draw_OLED_log(40);
    else if(val < MAX_WATER*0.60)
        Draw_OLED_log(60);
    else if(val < MAX_WATER*0.70)
        Draw_OLED_log(70);
    else if(val < MAX_WATER*0.80)
        Draw_OLED_log(80);
    else if(val < MAX_WATER*0.90)
        Draw_OLED_log(90);
    else if(val < MAX_WATER)
        Draw_OLED_log(100);
    else
        Draw_OLED_log(0);
        
}

void Draw_OLED_log(uint8_t val)
{
    SeeedGrayOled.setTextXY(0, 1);
    SeeedGrayOled.putString("more water");
        
    SeeedGrayOled.setTextXY(11, 0);
    SeeedGrayOled.putString("Reach to 2L");  
     
    switch(val)
    {
        case 0:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|    0 %  |");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
        case 10:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|   10 %  |");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
        case 30:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|   30 %  |");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
        case 40:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|   40 %  |");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
         case 60:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|   60 %  |");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
        case 70:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|~~ 70 %~~|");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
        case 80:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|~~ 80 %~~|");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
            case 90:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|~~ 90 %~~|");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
        case 100:
            SeeedGrayOled.setTextXY(1, 0);    
            SeeedGrayOled.putString("===========");
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|~~100 %~~|");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|~~~~~~~~~|");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
        default: // 20
            SeeedGrayOled.setTextXY(2, 0);
            SeeedGrayOled.putString("-----------");
            SeeedGrayOled.setTextXY(3, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(4, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(5, 0);
            SeeedGrayOled.putString("|    0 %  |");
            SeeedGrayOled.setTextXY(6, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(7, 0);
            SeeedGrayOled.putString("|         ~");
            SeeedGrayOled.setTextXY(8, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(9, 0);
            SeeedGrayOled.putString("|         |");
            SeeedGrayOled.setTextXY(10, 0);
            SeeedGrayOled.putString("-----------");
            break;
    }
}



