#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"

#define YourEventName "YOUREVENT"
#define YourSecretKey "YOURKEY"

#define DuringSafety 5  //hours

EthernetInterface eth;
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led(LED1);
AnalogIn sw(A0);
DigitalIn pir(D8,PullUp);
Timer timer;

int main()
{ 
    int phy_link;
    int flag = 0;
    int onetimeflag = 0;
    float sec = 0.0;
    
    pc.baud(115200);
   printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x12, 0x34, 0x56}; 
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    
    do{
         phy_link = eth.ethernet_link();
         printf("...");
         wait(2);
    }while(!phy_link);
    printf("\r\nIP Address is %s \r\n", eth.getIPAddress());
    TCPSocketConnection sock;

    // Initialize ifttt object, add up to 3 optional values, trigger event.
    IFTTT ifttt(YourEventName,YourSecretKey, &sock); // EventName, Secret Key, socket to use


    while(1) {
        
        if(!pir){
            led = 0;
            onetimeflag = 0;
            printf("Safety\r\n");
            if(!flag){
                timer.start();
                flag = 1;
            }
            wait(1);
        }
        else if(pir && (float)sw.read()>=0.9 && !onetimeflag){
            led=1;
            onetimeflag=1;
            printf("Thief Detected\r\n");
            ifttt.addIngredients("===WARNING===","The Thief was found","Report him to the police");
            ifttt.trigger();   
            timer.reset();
            wait(1);
        }
        sec = timer.read();
        if(sec > DuringSafety*3600 && (float)sw.read()>=0.9){
            timer.reset();
            ifttt.addIngredients("Your home in safety during",(char*)DuringSafety,"hours!");
            ifttt.trigger();    
        }
    }

}