/**
 * RemoteIR library - Test program.
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */
 
#include <mbed.h>

#include "EthernetInterface.h"
#include "TransmitterIR.h"
#include "RemoteIR.h"

TransmitterIR ir_tx(D5);
Serial pc(USBTX, USBRX);


int transmit(RemoteIR::Format format, uint8_t *buf, int bitlength, int timeout = 1000) {
    int cnt = 0;
    while (ir_tx.getState() != TransmitterIR::Idle) {
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_tx.setData(format, buf, bitlength);
}


void sort_data(char *buf, int n, char *type, char *cmd){
   
    bool flag = 0;
    int s = 0;
    int i, j;
    int addBinary = 1;
    int pontOfcommand = 0;
    //devide
    for(i=0;i<n;i++){
        if(buf[i]==','){
            flag = 1;
            s = i;
            continue;
        }    
        if(flag){
            j = i-(s+1);
            
            if(j%8 == 0 && j != 0) {pontOfcommand++; addBinary = 1;} 
            
            if(buf[i] == '1') cmd[pontOfcommand] += addBinary;

            addBinary*=2;
        }
        else
            type[i] = buf[i];
    }       
}

/**
 * Entry point.
 */
int main(void) {
    pc.baud(115200);
    RemoteIR::Format format;
    
    pc.printf("Wait a second...\r\n");

    int phy_link;
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    do{
        phy_link = eth.ethernet_link();
         pc.printf("...");
         wait(2);
     }while(!phy_link);
     printf("\r\n");
     pc.printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
     TCPSocketServer server;
     server.bind(5000);
     server.listen();
    
    
    while (1) {

        //char buf[50]="NEC,00100000110111110001000011101111\n";
   
        printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        printf("Connection from: %s\r\n", client.get_address());
             
            while (true) {
                char buf[50] = {0};
                char type[10] = {0};
                char cmd[4] = {0};
                int bitlength=0;
                int n = client.receive(buf, sizeof(buf));
                if(n <= 0) continue;
                
                // print received message to terminal
                //buf[n] = '\0';
                pc.printf("Received message from Client :\n %s\n",buf);
                
                sort_data(buf, n, type, cmd);
               
                if(!strncmp(type,"NEC",strlen("NEC")))
                    format = RemoteIR::NEC;
                else if(!strncmp(type,"AEHA",strlen("AEHA")))
                    format = RemoteIR::AEHA;
                else if(!strncmp(type,"SONY",strlen("SONY")))
                    format = RemoteIR::SONY;
                else if(!strncmp(type,"NEC_REPEAT",strlen("NEC_REPEAT")))
                    format = RemoteIR::NEC_REPEAT;
                else if(!strncmp(type,"AEHA_REPEAT",strlen("AEHA_REPEAT")))
                    format = RemoteIR::AEHA_REPEAT;
                else
                    format = RemoteIR::UNKNOWN;

                pc.printf("SEND HEX: %2x %2x %2x %2x\n",cmd[0],cmd[1],cmd[2],cmd[3]);

                    {
                        bitlength = transmit(format, (uint8_t*)cmd, 32);
                        if (bitlength < 0) {
                             continue;
                        }
                    }
                    client.close();
        }
        
   }
}
    
