#include "mbed.h"
#include "WizFi250Interface.h"
#include "ifttt.h"

#define SECURE WizFi250::SEC_AUTO
#define SSID "ssid"
#define PASS "password"

#define YourEventName "YourEventName"
#define YourSecretKey "YourSecretKey"

    WizFi250Interface wizfi250(D1,D0,D7,D8,PA_12,NC,115200);
    TCPSocketConnection sock;
    Serial pc(USBTX, USBRX); // tx, rx
    
int main()
{ 
    pc.baud(115200);
   
    pc.printf("WizFi250_IFTTT Send example. \r\n");
    wizfi250.init();
    wizfi250.connect(SECURE, SSID, PASS);
    pc.printf("IP Address is %s\r\n", wizfi250.getIPAddress());

    // Initialize ifttt object, add up to 3 optional values, trigger event.
    IFTTT ifttt(YourEventName,YourSecretKey, &sock); // EventName, Secret Key, socket to use
    ifttt.addIngredients("this is awesome","test-ing","data!!!");     // 3 optional Values to send along with trigger.
    ifttt.trigger();

    // Send data using GET
    ifttt.addIngredients("Sending","GET","data");
    ifttt.trigger(IFTTT_GET);

    // Send Data using POST
    ifttt.addIngredients("Sending","POST","things");
    ifttt.trigger(IFTTT_POST);
    
    sock.close();
    wizfi250.disconnect();
    
    while(1) {
    }
}

