#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"

EthernetInterface eth;
Serial pc(USBTX, USBRX); // tx, rx

int main()
{ 
    int phy_link;
    pc.baud(115200);
   
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    eth.init(mac_addr); //Use DHCP
    eth.connect();
    
    do{
         phy_link = eth.ethernet_link();
         printf("...");
         wait(2);
    }while(!phy_link);
    printf("\r\nIP Address is %s \r\n", eth.getIPAddress());
    TCPSocketConnection sock;

    // Initialize ifttt object, add up to 3 optional values, trigger event.
    IFTTT ifttt("YourEventName","ChangeToYourSecretKey", &sock); // EventName, Secret Key, socket to use
    ifttt.addIngredients("this is awesome","test-ing","data!!!");     // 3 optional Values to send along with trigger.
    ifttt.trigger();

    // Send data using GET
    ifttt.addIngredients("Sending","GET","data");
    ifttt.trigger(IFTTT_GET);

    // Send Data using POST
    ifttt.addIngredients("Sending","POST","things");
    ifttt.trigger(IFTTT_POST);
    
    sock.close();
    eth.disconnect();
    
    while(1) {
    }
}