// uCAM TTL(120) jpeg camera class for mbed
// J. Bradshaw 20141106

#include "mbed.h"
//define larger buffers for return packets
#define MODSERIAL_DEFAULT_RX_BUFFER_SIZE 1024
#define MODSERIAL_DEFAULT_TX_BUFFER_SIZE 1024 
#include "MODSERIAL.h"

#ifndef uCAM_TTL120_H
#define uCAM_TTL120_H

//uCAM command defines, page 8 of uCAM manual
#define uCAM_INITIAL            0xAA01
#define uCAM_GET_PICTURE        0xAA04
#define uCAM_SNAPSHOT           0xAA05
#define uCAM_SET_PACKAGE_SIZE   0xAA06
#define uCAM_SET_BAUD_RATE      0xAA07
#define uCAM_RESET              0xAA08
#define uCAM_DATA               0xAA0A
#define uCAM_SYNC               0xAA0D
#define uCAM_ACK                0xAA0E
#define uCAM_NAK                00xAA0F
#define uCAM_LIGHT              0xAA13

/**
 * uCAM_TTL120 Class.
 */
 
class uCAM_TTL120{
public:
    /**
     * Constructor.
     * @param tx - Serial port transmit pin
     * @param rx - Serial port recieve pin
     */ 
    uCAM_TTL120(PinName tx, PinName rx);
    int uCAM_read(char *str, int numchars, float timeout);

    void uCAM_Command_Send(int command,char p1,char p2,char p3,char p4);
    int uCAM_GetACK(int command);
    int uCAM_Connect(void);
    void uCAM_FlushBuffer(void);
    int uCAM_send_INITIAL_80x60_16RAW(void);
    int uCAM_send_INITIAL_80x60_2RAW(void);
    int uCAM_send_INITIAL_128x128_4RAW(void);
    int uCAM_send_SNAPSHOT(void);
    int uCAM_send_GET_PICTURE_80x60_16COL_RAW(FILE *fp);
    int uCAM_send_GET_PICTURE_80x60_2GRAY_RAW(void);
    int uCAM_send_GET_PICTURE_128x128_4GRAY_RAW(void);
    
    void uCAM_TakePic_RAW_16COLOR_80x60(FILE *fp);
    void uCAM_TakePic_RAW_2GRAY_80x60(void);
    void uCAM_TakePic_RAW_4GRAY_128x128(void);

    int uCAM_get_jpeg(FILE *fp);

    void uCAM_set_baud(void);

    char picture[10000];
    MODSERIAL _cam;
private:    
    Timer *timerCam; 
};

#endif /* uCAM_TTL120_H */
