// mbed_uCAM_TTL120_test.c
// J Bradshaw 11-06-2014
#include "mbed.h"
#include "uCAM_TTL120.h"
#include "stdio.h"
#include "stdlib.h"

LocalFileSystem local("local");// Create the local filesystem under the name "local"
Serial pc(USBTX,USBRX);    
uCAM_TTL120 cam(p9, p10);      //Tx/Rx
DigitalOut myled(LED1);
DigitalOut camrst(p15);
    
int main(){
    int fileNameCnt = 0;
    char fileNameStr[20];
                 
    pc.baud(921600);
    pc.printf("%s\r\n", __FILE__);        
            
    //camera reset line drives a FET for applying power to CAM (hardware reset)
    camrst = 0;
    wait(.2);
    camrst = 1;            

    if(cam.uCAM_Connect()){   //Initialize the uCAM connection
        pc.printf("Camera Initialized\r\n");
    }
    else{
        pc.printf("Camera failed to connect\r\n");
        exit(1);
    }          
    
    cam.uCAM_set_baud();     
        
    while(1) {                      
        sprintf(fileNameStr, "/local/pic%04X.jpg", fileNameCnt++);                    
        
        FILE *fp = fopen(fileNameStr, "w");            
        cam.uCAM_get_jpeg(fp);              
        fclose(fp);      
    /*
        cam.uCAM_send_INITIAL_80x60_16RAW();
        wait(.1);
        cam.uCAM_send_SNAPSHOT();
        wait(.1);
        cam.uCAM_send_GET_PICTURE_80x60_16COL_RAW();
    */
            
        myled = 1;
        wait(.2);
        myled = 0;
        wait(.2);
    }
}
