// J. Bradshaw 20190228
// Program for testing Motor control port on SY202 application board to L293 interface
#include "mbed.h"
#include "MotCon.h"     //uses the MotCon.h library for controlling the motor ports
#include "C12832_lcd.h"

//PC serial connection
Serial pc(USBTX, USBRX);    //tx, rx via USB connection
DigitalOut led(LED1);
MotCon m1(p23, p24, p25);   //uses p23 for pwm and p24 and p25 for direction (complimentary)
C12832_LCD lcd;

//------------ Main ------------------------------
int main() {    
    wait(.2);       //short delay
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("SY202 Motor Test");             
    
    pc.baud(921600);//fast baud rate for USB PC connection
    while(1) {
        //iterate through 2*pi cycles in .01 increments
        for(float cycle=0;cycle<3.14159*2.0;cycle+=.01){
            float m1_dc = .85*sin(cycle);            
            m1.mot_control(m1_dc);                        
            
            lcd.locate(0,8);
            lcd.printf("cycle=%.2f dc=%7.2f \n", cycle, m1_dc);
            
            lcd.locate(0,16);
            if(m1_dc > 0.001)
                lcd.printf("Forward\n");
            else if(m1_dc < 0.001)
                lcd.printf("Reverse\n");
                
            pc.printf("cycle=%.3f  m1_dc = %.2f \r\n", cycle, m1_dc);
            wait(.01);      //determines period
            led = !led;     //toggle LED1 to indicate activity
        }
    }
}