// J Bradshaw  20160304  Hokuyo Lidar interface library example
// cluster - groups together points, each point is .351 degrees
#include "mbed.h"
#include "hokuyo.h"

DigitalOut led1(LED1);
Hokuyo lidar(p13, p14); // tx, rx for Xbee header (RS232 board for Hokuyo)
Serial pc(USBTX, USBRX);

int main() {
    float scan_width = 180.0;   //scan X number of degrees
    int cluster = 3;            //~degree 1 accuracy with every 3 samples at .351/sample
    
    pc.baud(921600);

    if(!lidar.Init())
        pc.printf("Hokuyo Init successful\r\n");
    else{
        pc.printf("Error Initializing Hokuyo!\r\n");
        wait(10);
    }
          
    while(1) {        
        if(!lidar.Read_Scan(scan_width, cluster)){        //scan 30deg wide, cluster of 5 points
            //pc.printf("total points read = %d\r\n\r\n", lidar.numPts);        
            for(int i=0;i<lidar.numPts;i++){
                 pc.printf("%5.2f %05d\r\n", lidar.angle[i], lidar.dist_mm[i]);
                 wait(.0001);
            }
            led1=!led1;
        }
        else
            pc.printf("Error Scanning Hokuyo!\r\n");
    }
}
