// J. Bradshaw 20180918
// Program for testing I/O on mbed ES201 Dev Board V1.1
#include "mbed.h"
#include "ServoOut.h"   //uses ServoOut.h library for generating servo pulses
#include "MotCon.h"     //uses the MotCon.h library for controlling the motor ports
#include "rtos.h"

#define PI 3.1415926

char DB9_M_char;

DigitalOut led1(LED1);
DigitalOut led3(LED3);

//PC serial connection
Serial pc(USBTX, USBRX);    //tx, rx via USB connection
I2C i2c(p9,p10);    //SDA, SCL
Serial DB9_male(p13, p14); //DB9 serial male

//Port J5
BusOut bus_J5(p5, p6, p7, p8, p11);

//header for J5
DigitalOut J5_p5(p5);
DigitalOut J5_p6(p6);
DigitalOut J5_p7(p7);
DigitalOut J5_p8(p8);
DigitalOut J5_p11(p11);

//Analog port in J6
AnalogIn    J6_P16(p16);
AnalogIn    J6_P17(p17);
AnalogIn    J6_P18(p18);
AnalogIn    J6_P19(p19);
AnalogIn    J6_P20(p20);

// servo ports p21 - p24
ServoOut sv1(p21);
ServoOut sv2(p22);
ServoOut sv3(p23);
ServoOut sv4(p24);

/*
DigitalOut mot1_ph1(p28);
DigitalOut mot1_ph2(p27);
PwmOut mot_en1(p25);

DigitalOut mot2_ph1(p29);
DigitalOut mot2_ph2(p30);
PwmOut mot_en2(p26);
*/

MotCon m1(p25, p27, p28);
MotCon m2(p26, p29, p30);

void mot1_thread(void const *args){
        while(1){
        // Run PWM and servo command signals
        for(float cycle=0;cycle<2.0*PI;cycle+=.078){
            sv1 = 1500 + (int)(sin(cycle)*500);
            sv2 = 1500 + (int)(cos(cycle)*500);
            sv3 = 1500 + (int)(sin(cycle)*500);
            sv4 = 1500 + (int)(sin(cycle)*500);
        
            m1.mot_control(.85*sin(cycle));
            m2.mot_control(.85*cos(cycle));
                        
            pc.printf("cycle = %.2f  \r", cycle);
            Thread::wait(10);
        } 
    }//while(1)
}

void digOut_thread(void const *args){
    //toggle bus I/O for testing
    while(1){
        bus_J5 = 0x1f;
        Thread::wait(500);
        bus_J5 = 0xAA;
        Thread::wait(100);
        bus_J5 = 0x55;
        Thread::wait(100);
        bus_J5 = 0xAA;
        Thread::wait(100);
        bus_J5 = 0x55;
        Thread::wait(100);        
        bus_J5 = 0; //all off
        Thread::wait(500);    
    }
}

void led1_flash(void const *args){
    while(1){
        led1 = !led1;
        Thread::wait(500);
    }
}

void serial_DB9M_test(void const *args){
    while(1){        
        for(char tx_char='a';tx_char <= 'z';tx_char++){
            DB9_male.printf("%c", tx_char);
            
            if(DB9_male.readable()){
                DB9_M_char = DB9_male.getc();
            }            
            Thread::wait(100);
        }
    }        
}

void i2c_test(void const *args){
    while(1){        
        //i2c.write(0x55);
        Thread::wait(10);
    }        
}
//------------ Main ------------------------------
int main() {
    float analogVal[6];
    
    i2c.frequency(100000);
    pc.baud(9600);
    DB9_male.baud(9600);
    
    Thread t1(mot1_thread);
    Thread t2(digOut_thread);
    Thread t3(led1_flash);
    Thread t4(serial_DB9M_test);
    Thread t5(i2c_test);
        
    while(1) {        
        analogVal[0] = J6_P16;
        analogVal[1] = J6_P17;
        analogVal[2] = J6_P18;
        analogVal[3] = J6_P19;
        analogVal[4] = J6_P20;
        pc.printf("%.2f %.2f %.2f %.2f %.2f DB9M=%c\r\n", analogVal[0],analogVal[1],analogVal[2],analogVal[3],analogVal[4], DB9_M_char);            
        wait(.05);
    }
}
