// Example of parsing the serial string from the DF Robot Joystick with the mbed
#include "mbed.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);    //tx, rx via USB connection
Serial xbee(p13, p14);    //tx, rx via Xbee socket
    
int main() {
    char joystr[100];   //used to store the whole joystick string
    int buttonsAll;     //16bit representation of all buttons
    int button[16];     //individual button states (normally high)
    int js_lr_L;        //Left Joystick Left/Right movement
    int js_ud_L;        //Left Joystick Up/Down movement
    int js_lr_R;        //Right Joystick Left/Right movement
    int js_ud_R;        //Right Joystick Up/Down movement
    int chksum;         //checksum for error correction
            
    pc.baud(921600);    //crank up the PC baudrate (USB) to avoid latency between data acquisition
    xbee.baud(9600);
    
    pc.printf("\r\n\r\n%s\r\n", __FILE__);
        
    while(1) {                
        while(xbee.readable())      //clear out the remaining characters in the buffer
            char c = xbee.getc();
            
        //read the serial string from the xbee (starts with '$', ends with \r\n            
        xbee.scanf("$%s\r\n", &joystr);    
            
 //       pc.printf("%s\r\n", joystr);     //used for debugging
  
        if(!strncmp(joystr, "JOYSTK", 6)){
            if (sscanf(joystr, "JOYSTK,%X,%d,%d,%d,%d*%X", &buttonsAll, &js_lr_L, &js_ud_L, &js_lr_R, &js_ud_R, &chksum) >= 1) {
     
                 // iterate through buttonsAll (each bit) to assign value MSB first
                for(int i=15;i>=0;i--){
                    if(buttonsAll & (1 << i))
                        button[i] = 1;
                    else
                        button[i] = 0;
                    pc.printf("%1d ", button[i]);
                }
                
                //pc.printf("%7 %5d %5d %5d %5d 0x%02X\r\n", buttonsAll, js_lr_L, js_ud_L, js_lr_R, js_ud_R, chksum);
                pc.printf("%5d %5d %5d %5d\r\n", js_lr_L, js_ud_L, js_lr_R, js_ud_R);
            }
            else{
                pc.printf("BAD parse %s\r\n", joystr);    
            }
        }      
        myled = !myled; //toggle LED for activity verification
    }//while(1)
}//main
