// J. Bradshaw 20150409
/** ServoIn Class for Reading servo pulses on single input pin
 * Copyright (c) 2014, jbradshaw (http://mbed.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
*/

#ifndef MBED_SERVOIN_H
#define MBED_SERVOIN_H

/**
 * ServoIn Class.
 */
 
 class ServoIn {
public:
    /**
    * Constructor.
    *
    * @param pin - servo pulse input pin, assigned as interrupt in
    */         
    
    ServoIn(PinName pin);
            
    int servoPulse;
    int servoPulseMax;
    int servoPulseMin;
    float servoPulseOffset;
    float servoPulseScale;
    
    float readCalPulse(void);
    int read(void);
    void PulseRead(void);
    void timeoutTest(void);
    
    ServoIn& operator= (ServoIn& rhs);
    operator int();
    
private:
    InterruptIn _interrupt;
    DigitalIn _pin;
    Timeout _validPulseTimeout;
    bool _pulseFlag;
    Timer   pulseMeasure;
    bool _t_state;
};

#endif
