// J Bradshaw 20160304
#include "mbed.h"

#ifndef HOKUYO_H
#define HOKUYO_H

#define MAXBUFSIZE 1024

/**  A Hokuyo Lidar interface */
class Hokuyo {
public:
    Hokuyo(PinName tx, PinName rx);
    
    int lidar_read(char *str, int numchars, float timeoutDelay);    //serial read function with timout (for large and non ASCII data strings)
    int Read_Scan(float scan_deg, int clust_size);                  //send scan command and read data
    int Init(void);                                                 //Initialize the Hokuyo lidar
    
    int numPts;                                                     //total number of points scanned from Read_Scan function
    float angle[MAXBUFSIZE];                                        //angle array
    int dist_mm[MAXBUFSIZE];                                        //distance array
private:
    Serial _hokuyo;                                                 //serial port connected to Hokuyo
    
};

#endif