/* --------------------------------------------------------------------------
// test compile ok 31/07/2020 

// 30/08/2020 : emission CAN OK en Wifi sur tasmota ou udp bridge
//              mais pb reception caracteres sur port serie ( idem port series pc ouu serial 7

// 02/08/2020
// add sd parameters: read ok
// ip address
// ethernet actif
// wifi actif
// can actif
// serial actif
// fonction
// Touche1 status (0/1)
// Touche1 backcolor
// touche1 text color
// Touche1 text
// Touche1 text1
// Touche2
// Touche3
// Touche4
// Temp1 text
// Temp2 text

// works ok 31/07/2020
// updated package from jpa
// added fonts in  bsp_disco_f746ng/utilities/fonts
// fonts.h updated to manage added fonts
// grovestream.cpp & grovesttream.h updated
// remove stm32746ng_dicovery_sd in /bsp_disco_f746ng/drivers/stm32746ng_discovery
// mainSDAcardJPA issue: add sdcardjpa.cpp in lib /sdfilesystem_warning_fixed
// isue with big fonts: replace /bsp_disco_f746ng/drivers/stm32746ng-discovery/stm32746ng-discovery_lcd.c &.h

// need to add CAN and WiFi

 STM32F746 GroveStreams Stream Feed via Ethernet

 This GroveStreams example is designed for the STM32F746.
 https://www.grovestreams.com/developers/getting_started_stm32F746.html

 The STM32 uses DHCP and DNS for a simpler network setup.

*/

#if !FEATURE_LWIP
#error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "LcdDiscoF746NgTracer.h"
#include "GroveStreams.h"
#include "MbedJSONValue.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "CANMsg.h"
//#include "ManageBufferJPA.h"

#include "main.h"


//#include "touchScreen.cpp"
int touchInitJPA1();
int touchJPA1();
int touchInitGuiJPA1();
int sendTouchJPA(int xx);
time_t lastToucheTime = 0;
int touchButtonJPA1(int numButton);

//#include "GuiJPA.cpp"
int initDisplayTemp();
int initDatasGuiJPA();
int setTemp1(std::string temp1);
int setTemp2(std::string temp2);
int sendInitDatasJPA(int xx);

//#SDCARD
int mainSDCardJPA(); //in sdcardjpa.cpp in lib /sdfilesystem_warning_fixedd

//GroveStreams Stream IDs. Stream IDs tell GroveStreams which component streams the values will be assigned to.
//Don't change these unless you edit your GroveStreams component definition and change the stream IDs to match these.
const char      gsStreamId1[] = "voltage";
const char      gsStreamId2[] = "temperature";
char            gsStreamIPdatas[] = "192.168.1.49";
char            ethernet_actif[] = "O";
char            wifi_actif[] = "O";
char            can_actif[] = "O";
char            serial_actif[] = "O";
char            read_sd[] = "";
uint8_t         text2[30];
uint8_t         counter = 0;
float           voltage;

Timer           timer;
AnalogIn        analogIn(A0);

// CAN ------------------------------------------------------------
CAN             can(PB_8, PB_9);  // CAN Rx pin name, CAN Tx pin name
CANMsg          rxMsg;
CANMsg          txMsg;

// Other Settings
int             updateFrequency = 20;    // Update frequency in seconds. Change this to change your sample frequency.

AnalogIn        adc_temp(ADC_TEMP);
AnalogIn        adc_vref(ADC_VREF);
DigitalOut      myled(LED1);

void initSerial();
void sendSerialUSB(char * str);
void receiveSerialUSB();
void sendSerial2(char * str);
void receiveSerial2();
void sendSerial7(char * str);
void receiveSerial7();

//extern volatile char            bufferSerialUSB[];
extern volatile int             msgSerialUSB;
extern char                     stringSerialUSB[];               // trame from serialUSB
extern int                      stringSerialUSBok;               // si ==1 alors trame dispo (fin de trame == LF ou 10

extern volatile int             msgSerial2;
extern char                     stringSerial2[];               // trame from serialUSB
extern int                      stringSerial2ok;               // si ==1 alors trame dispo (fin de trame == LF ou 10

extern volatile int             msgSerial7;
extern char                     stringSerial7[];               // trame from serialUSB
extern int                      stringSerial7ok;               // si ==1 alors trame dispo (fin de trame == LF ou 10

//extern Serial          serialUSB(USBTX, USBRX);    // serial PC
//extern Serial          serial2(PC_6, PC_7); // TX, RX for udp bridge
//extern Serial          serial7(PF_7, PF_6); // TX, RX for extension

#define BOARD1                  1       // comment out this line when compiling for board #2
    const unsigned int  RX_ID = 0x101;
    const unsigned int  TX_ID = 0x100;


// ---------------------------------------------------------------------------------------
//* @brief   Prints CAN message to PC's serial terminal
void printMsg(CANMessage& msg, int dir)
{   if (dir ==0)
    {  //BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"Message sent    ", LEFT_MODE); 
         printf(" Can message sent : ");
         printf("ID = 0x%.3X Data=", msg.id);
         for(int i = 0; i < msg.len; i++) printf(" 0x%.2X", msg.data[i]);
        printf("\n");       
    }    
    else
    {  
         printf(" Can message receive : ");
        /*
        printf("  ID      = 0x%.3X\r\n", msg.id);
        printf("  Type    = %d\r\n", msg.type);
        printf("  Format  = %d\r\n", msg.format);
        printf("  Length  = %d\r\n", msg.len);
        */
        printf("ID = 0x%.3X Data=", msg.id);
        for(int i = 0; i < msg.len; i++) printf(" 0x%.2X", msg.data[i]);
        printf("\n");
    }
}

/** -----------------------------------------------------------------------------------------
 * @brief   Handles received CAN messages
 * @note    Called on 'CAN message received' interrupt.
 */
int CanRcv = 0;
void onCanReceived(void)
{   
    can.read(rxMsg);
    CanRcv = 1;
}


// ------------------------------------------------------------------------------------------
int main()
{   
    initSerial();

    
   // attach ISR to handle received messages
    timer.start();          // start timer
    sendSerialUSB("CAN_Hello board serialUSB #1\r\n");
    sendSerial2("CAN_Hello board serial2 #1\r\n");
    sendSerial7("CAN_Hello board serial7 #1\r\n");
    
    printf("\nInit SDCard ...\n");
    mainSDCardJPA() ;  // init SD - read  prog parameters from SD (from sdcardjpa.cpp in sdfilesystem_warning_fixed lib
    // reaf following datas
    // IP address, Ethernet actif, Wifi actif, Can actif, serial actif,fonction, buttons parameters
    // store local variables from sd
    //extern char gsStreamIPdatas[];
    //extern char ethernet_actif[] ;
    //extern char wifi_actif[];
    //extern char can_actif[];
    //extern char serial_actif[];
    printf("\nFin init SDCard ...\n");
    BSP_LCD_Clear(LCD_COLOR_DARKBLUE);  // clear LCD
    uint8_t text[300];
    printf("Start Prog\n");    
    std::string temp1;
    std::string temp2;
    
    //lastSuccessfulUploadTime is used for upload frequency.
    time_t lastSuccessfulUploadTime = 0;    
    printf("\n Init touchJPA1 ...\n");
    int yy;
    printf("\n Init initDisplayTemp ...\n"); 
    yy = initDisplayTemp();   // from guijpa.cpp - Init display
    printf("\ninit touchInitJPA1 ...\n");
    yy = touchInitJPA1();  // from touchscreen.cpp - init touchscreen
    yy = touchInitGuiJPA1();  // from touchscreen.cpp 
    printf("\ninit initDatasGuiJPA ...\n");
    yy = initDatasGuiJPA();  // from guijpa.cpp - config buttons             
    ////lcd.printf("Starting...");
    printf("Starting...\n");
    lastToucheTime = time(NULL);
     char data[5];
     
   // config can --------------------------------------
    can.frequency(125000); // set CAN bit rate to 125 kbps
    //can.filter(RX_ID, 0xFFF, CANStandard, 0); // set filter #0 to accept only standard messages with ID == RX_ID
    can.attach(onCanReceived, CAN::RxIrq);   
    
    BSP_LCD_DisplayOff();
    BSP_LCD_DisplayOn();
    // main loop ---------------------------------------------------
    while (true) {
        
        if (CanRcv > 0)
            {
            CanRcv = 0;    
            printMsg(rxMsg,1);  
            BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Can msg rec", CENTER_MODE);
            if (rxMsg.id == RX_ID) {
                rxMsg >> counter;
                rxMsg >> voltage;    
                //serialUSB.printf("  counter = %d\r\n", counter);
                //serialUSB.printf("  voltage = %e V\r\n", voltage);
                 }
            }

        if (msgSerialUSB > 0) {receiveSerialUSB();}
        if (stringSerialUSBok == 1) {printf("Trame SerialUSB : %s",stringSerialUSB);stringSerialUSBok=0;}
        
        if (msgSerial2 > 0) {receiveSerial2();}
        if (stringSerial2ok == 1) {printf("Trame Serial2 : %s",stringSerial2);stringSerial2ok=0;}
        
        if (msgSerial7 > 0) {receiveSerial7();}
        if (stringSerial7ok == 1) {printf("Trame Serial7 : %s",stringSerial7);stringSerial7ok=0;}
     
        // timer send can 
       if(timer.read_ms() >= 10000)            // check for timeout
       {    
            
            timer.stop();                       // stop the timer
            timer.reset();                      // reset the timer
            counter = (counter+1) & 1;                          // increment the counter
            voltage = 0;////(analogIn * 3.3f)/4096.0f;// read the small drifting voltage from analog input
            txMsg.clear();                      // clear the Tx message storage
            txMsg.id = 0x100130CA;//TX_ID;                   // set the message ID
            txMsg.format = CANExtended ; //extended
            txMsg.len=2;
            txMsg.data[0]=8;txMsg.data[1]=counter;        // append data (total data length must be <= 8 bytes!)
            
            if(can.write(txMsg))       // transmit message
            {   //if(can->write(txMsg)) {             // transmit the CAN message
                printMsg(txMsg,0);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
            }
            else
            {   //serialUSB.printf("Transmission error\r\n");
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
            timer.start();                  // insert transmission lag
        }  // end if timer
        //touch screen
        int xx = touchJPA1();  //
        if (xx > 0) 
        {  
           if (xx == 4)
           { // send trame to can
            txMsg.id = 0x100130CB;//TX_ID;                   // set the message ID
            txMsg.format = CANExtended ; //extended
            txMsg.len=2;
            txMsg.data[0]=8;txMsg.data[1]=2;        // append data (total data length must be <= 8 bytes!)
          
           if(can.write(txMsg))       // transmit message
            {   
                printMsg(txMsg,0);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
             }
            else
            {
                BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
           }    
           xx = sendTouchJPA(xx);  
            
           lastToucheTime = time(NULL);
           
        } 
        else 
        {  lastToucheTime = 0;
        }   // send mqtt
        // Update sensor data to GroveStreams
        time_t seconds = time(NULL);
        if(seconds - lastSuccessfulUploadTime > updateFrequency) {
            ////lcd.clear();            
            ////lcd.printf("Getting Samples...");
            printf("Getting Samples...\n");          
            //Assemble the samples into URL parameters which are seperated with the "&" character
            // Example: &s1=6.2&s2=78.231
            int temperature = 0; //adc_temp.read() * 100.0f;
            int voltage = 0; //adc_vref.read() * 100.0f;
            char samples[64] = {0};
            sprintf(samples, "&%s=%d&%s=%d", gsStreamId1, voltage, gsStreamId2, temperature);           
            //Append on command requests (request stream values)
            //This will indicate to GroveStreams to return the last value
            // of each request stream during the sample upload
            strcat(samples, "&rsid=freq&rsid=led");            
            char resultBuffer[700]= {0};
            //Sending Samples (and returning current command stream values)
            time_t connectAttemptTime = time(NULL);
            int sendResult = groveStreams.send(myMac, samples, gsCompName, gsCompTmplId, resultBuffer, sizeof resultBuffer);  //receive mqtt
            
            if (sendResult == 0) {
                ////lcd.printf("Send Successful");
                printf("Send Successful\n");
                lastSuccessfulUploadTime = connectAttemptTime;               
                //Handle command streams
                if (strlen(resultBuffer) > 0 && resultBuffer[0] == '{') {
                    MbedJSONValue mbedJson;
                    parse(mbedJson, resultBuffer);                    
                    sprintf((char*)text, "HTTP string : %s\n", resultBuffer);
                    //BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);                
                    if (mbedJson.hasMember("Temp1")) {
                        int pp=setTemp1(mbedJson["Temp1"].get<std::string>());
                    }
                    if (mbedJson.hasMember("Temp2")) {
                        int tt=setTemp2(mbedJson["Temp2"].get<std::string>());
                    }
                    if (mbedJson.hasMember("led")) {
                        //Change LED
                        myled = mbedJson["led"].get<bool>() ? 1 : 0;
                        ////lcd.printf("LED: %s", mbedJson["led"].get<bool>() ? "On" : "Off");
                        printf("LED: %s\n", mbedJson["led"].get<bool>() ? "On" : "Off");
                    }
                }
            } 
        }
        
    }
}


