/*
 * An example showing how to use the mbed CAN API:
 *
 * Two affordable (about $2 on ebay) STM32F103C8T6 boards (20kB SRAM, 64kB Flash),
 * (see [https://developer.mbed.org/users/hudakz/code/STM32F103C8T6_Hello/] for more details)
 * are connected to the same CAN bus via transceivers (MCP2551 or TJA1040, or etc.).
 * CAN transceivers are not part of NUCLEO boards, therefore must be added by you.
 * Remember also that CAN bus (even a short one) must be terminated with 120 Ohm resitors at both ends.
 *
 *
 * The same code is used for both mbed boards, but:
 *      For board #1 compile the example without any change.
 *      For board #2 comment out line 21 before compiling
 *
 * Once the binaries have been downloaded to the boards reset both boards at the same time.
 *
 */

//#define TARGET_STM32F103C8T6    1       // uncomment this line to use STM32F103C8T6 boards

#define BOARD1                  1       // comment out this line when compiling for board #2

#if defined(TARGET_STM32F103C8T6)
    #define LED_PIN     PC_13
    const int           OFF = 1;
    const int           ON = 0;
#else
    #define LED_PIN     LED1
    const int           OFF = 0;
    const int           ON = 1;
#endif
    const unsigned int  RX_ID = 0x101;
    const unsigned int  TX_ID = 0x100;

#include "mbed.h"
#include "CANMsg.h"
#include "CANJpa.h"

//Serial              pc(PA_2, PA_3);

void init_can();
void can_write();


/**
 * @brief   Main
 * @note
 * @param
 * @retval
 */
int main(void)
{
    pc.baud(9600);          // set serial speed
    init_can();
    led = ON;               // turn the LED on
    timer.start();          // start timer
    while(1) {
        if(timer.read_ms() >= 2000) {    // check for timeout
            timer.stop();                // stop timer
            timer.reset();               // reset timer
            can_write();

        }
    }
}
