#ifndef CANJpa_H
#define CANJpa_H

extern Serial              pc(PA_2, PA_3);
extern CAN                 can(PA_2, PA_3);  // CAN Rx pin name, CAN Tx pin name
//CAN                 can(p30, p29);  // CAN Rx pin name, CAN Tx pin name
CANMsg              rxMsg;
CANMsg              txMsg;

uint8_t             counter = 0;
AnalogIn            analogIn(A0);
float               voltage;
Timer               timer;
DigitalOut          led(LED_PIN);

/**
 * @brief   Prints CAN message to PC's serial terminal
 * @note
 * @param   CANMessage to print
 * @retval
 */
void printMsgCan(CANMessage& msg)
{
    pc.printf("  ID      = 0x%.3x\r\n", msg.id);
    pc.printf("  Type    = %d\r\n", msg.type);
    pc.printf("  Format  = %d\r\n", msg.format);
    pc.printf("  Length  = %d\r\n", msg.len);
    pc.printf("  Data    =");
    for(int i = 0; i < msg.len; i++)
        pc.printf(" 0x%.2X", msg.data[i]);
    pc.printf("\r\n");
}


/**
 * @brief   Handles received CAN messages
 * @note    Called on 'CAN message received' interrupt.
 * @param
 * @retval
 */
void onCanReceived(void)
{
    can.read(rxMsg);
    pc.printf("-------------------------------------\r\n");
    pc.printf("CAN message received\r\n");
    printMsgCan(rxMsg);

    if (rxMsg.id == RX_ID) {
        // extract data from the received CAN message 
        // in the same order as it was added on the transmitter side
        rxMsg >> counter;
        rxMsg >> voltage;    
        pc.printf("  counter = %d\r\n", counter);
        pc.printf("  voltage = %e V\r\n", voltage);
    }
    timer.start(); // to transmit next message in main
}

void can_write()
    {
            counter++;                   // increment counter
            voltage = analogIn * 3.3f;   // read the small drift voltage from analog input
            txMsg.clear();               // clear Tx message storage
            txMsg.id = TX_ID;            // set ID
            // append data (total data length must not exceed 8 bytes!)
            txMsg << counter;   // one byte
            txMsg << voltage;   // four bytes
             
            if(can.write(txMsg)) {       // transmit message
                led = OFF;               // turn the LED off
                pc.printf("-------------------------------------\r\n");
                pc.printf("-------------------------------------\r\n");
                pc.printf("CAN message sent\r\n");
                printMsgCan(txMsg);
                pc.printf("  counter = %d\r\n", counter);
                pc.printf("  voltage = %e V\r\n", voltage);
            }
            else
                pc.printf("Transmission error\r\n");
      }
          
void init_can()
    {
    can.frequency(1000000); // set CAN bit rate to 1Mbps
    can.filter(RX_ID, 0xFFF, CANStandard, 0); // set filter #0 to accept only standard messages with ID == RX_ID
    can.attach(onCanReceived);                // attach ISR to handle received messages   
    pc.printf("CAN_Hello board start\r\n");
    }

#endif // CANJpa_H