#include "mbed.h"
#include "stepmotor.h"
#include "draw.h"
#define CM_EJECUTAR 0xff
#define CM_GUARDAR 0xfe
#define CM_VERTEX2D 0xfd
#define CM_DRAW 0xfc
#define CM_NODRAW 0xfb
#define CM_STOP 0xfa
#define CM_END 0xf0
#define CM_CUADRANTE 0xf9
#define MEM_SIZE 5000
#define MEM_TYPE uint32_t

int mem_head = 0;
int mem_tail = 0;
uint32_t full = 0;

MEM_TYPE buffer[MEM_SIZE];
Serial command(USBTX, USBRX);
stepmotor smotor1(D9,D10,D11,D12);

void mem_free()
{
 mem_head=0;
 mem_tail=0;
 full=0;
}

void cuadrante()
{
    uint32_t speed=1500;
    uint8_t cw;
    int mover;
    smotor1.set_speed(speed);  
    if ( mover != 0 )
        {
            if(cw == 1)
            {smotor1.step(1633*mover,cw);}
            if(cw == 0)
            {smotor1.step(1633*mover,cw);}
            
        }
}

uint32_t mem_put(MEM_TYPE data)
{
    if (full)
        return 1;
    buffer[mem_head] = data;
    mem_head += 1;
    if (mem_head == MEM_SIZE)
        full =1;
    return 0;
}
uint32_t mem_get(MEM_TYPE* data)
{
    if (mem_head == 0)
        return 1; 
    if (mem_head == mem_tail)
        return 1; 
    
 
    *data = buffer[mem_tail];
    mem_tail += 1;
  
    return 0;
}
 
void ejecutar(){
    command.printf("se esta ejecutando el dibujo...");
    if(full==0){
      command.printf("memoria vacia");
      }
      else{
      for(int i=1;i<=mem_tail;i++)
          {
               command.printf("%x\n",buffer[i]);
          }
      }
    // ubicar acà el codigo 
}
void guardar(){
    uint32_t dato;
    uint8_t val; 
    command.printf("___SE INICIA COMANDO GUARDAR... SELECCIONE: (fd- vertex2d) (fc- draw)(fb - nodraw)(fa - menu principal)(f9 - cuadrante)_____ ");    
    // ubicar acà el codigo
    mem_free();
    val = command.getc();
    while( val != CM_STOP)
    {
        
        switch (val){
            
            case CM_CUADRANTE:
                dato=val<<8;
                command.printf("___SELECCIONE DIRECCION: 1- ADELANTE 0- ATRAS");
                val=command.getc();
                dato=(dato+val)<<8;
                mem_put(dato);
                command.printf("____NUMERO DE CUADRANTES QUE SE DESEA MOVER");
                val=command.getc();
                dato=(dato+val)<<8;
                mem_put(dato);
                command.printf("____CIERRE LINEA DE DATOS... ");
                val=command.getc();
                dato=(dato+val); 
                mem_put(dato);
                
            break;
            case CM_VERTEX2D:
                dato=val<<8;
                command.printf("___SUMINISTRE POSICION  1... ");
                val=command.getc();
                dato=(dato+val)<<8;
                mem_put(dato);
                command.printf("___SUMINISTRE POSICION  2... ");
                val=command.getc();
                dato=(dato+val)<<8;
                mem_put(dato);
                command.printf("___CIERRE LINEA DE DATOS... ");
                val=command.getc();
                dato=(dato+val); 
                mem_put(dato);
                
            break;
            
            case CM_DRAW:
                dato=val<<8;
                val=command.getc();
                dato=(dato+val); 
                mem_put(dato);                
            break;
            
            case CM_NODRAW:
                dato=val<<8;
                val=command.getc();
                dato=(dato+val); 
                mem_put(dato); 
            break;
            
            default: command.printf("valor erroneo");break ; 
      }
      command.printf("_____SELECCIONE: (fd- vertex2d) (fc- draw)(fb - nodraw)(fa - menu principal)(f9 - cuadrante)____");  
      val=command.getc();
      mem_put(dato);
    }
}
void init_serial()
{
    command.baud(9600);    
}
void read_cc(){
    command.printf("____MENU PRINCIPAL -- (ff f0 - ejecutar) (fe f0 - guardar)_____  ");
    char read_cc = command.getc();
    char end = command.getc();
    switch (read_cc) {
           case  CM_EJECUTAR: ejecutar(); break;
           case  CM_GUARDAR: guardar(); break;
           default: command.printf("error de comando");break ; 
    }
}

int main() {
    init_servo();
    init_serial();
    home();  
    while(1)
    {  
        read_cc(); 
    }
}
