#include "mbed.h"
#include <mpr121.h>
#include <VS1053.h>
#include <ADXL345.h>
#include <ctime>
#include <stdlib.h>
#include <math.h>
#include "TextLCD.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
PwmOut tone(p21);
AnalogIn   slider(p20);
ADXL345 accelerometer(p5, p6, p7, p8);
Serial pc(USBTX, USBRX);
I2C i2c(p28, p27); //For touch sensor
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS); //touch sensor class
TextLCD lcd(p12, p13, p14, p15, p16, p17);

// Tickers for game loop functions
Timeout ticker1;
Timeout ticker2;

InterruptIn TouchPad(p26);
InterruptIn AccTap(p11);
DigitalOut myled5(p29);
DigitalOut myled6(p30);
volatile int Test = 0x0000;
volatile int check = 0;
volatile int i;
volatile int c = 0;
volatile int command = 1;
volatile int ButtonsPressed = 0x0000;
volatile float slid = 0.0;
volatile float Prevslid = 0.0;
volatile float time1 = 2000000;
volatile float time2 = 1500000;
volatile int commandtemp = 0;
volatile int commandarray[20];
volatile int fail = 0;

void CheckInput(void);

void AccTapISR() {
    if (command == 1) {
        myled4 = !myled4;
        command = 0;
    } else {
        fail = 1;
    }
}

void TouchPadISR() {
    myled5 = !myled5;
    if (command == 2) {
        //ButtonsPressed |= mpr121.read(0x00);
        mpr121.read(0x00);
        //ButtonsPressed |= mpr121.read(0x01)<<8;
        ++ButtonsPressed;
        if ((ButtonsPressed >= 6) && (ButtonsPressed < 12)) { //0x0F9F) {
            myled4 = !myled4;
            ButtonsPressed = 0;
            command = 0;
            fail = 0;
        } else if (ButtonsPressed > 12) {
            fail = 21;
        }


    } /*else {
        fail = 23;
        ButtonsPressed = 0;
    }*/
}


///Ticker1 function to generate random command number from 1-3
void Command() {
    myled6 = !myled6;
    // command = 1;
    check = 1;
    command = commandarray[c];
    c++;
    if ( c == 20) c = 0;
    lcd.cls();
    if (command == 1) {
        //lcd.printf("Bop-It!\n");
        myled1 = 1;
        myled2 = 0;
        myled3 = 0;
    } else if (command == 2) {
        //lcd.printf("Square-It!\n");
        myled1 = 0;
        myled2 = 1;
        myled3 = 0;
    } else if (command == 3) {
        //lcd.printf("Slide-It!\n");
        myled1 = 0;
        myled2 = 0;
        myled3 = 1;
    }
    tone = .5;
    ticker2.attach_us(&CheckInput,time2 );

    time2 = time2 - 50000;
}

void CheckInput() {
    ticker1.attach_us(&Command,time1);
    time1 = time1 - 50000;
    if (command == 3) {
        Prevslid = slid;
        slid = slider;
        if (abs(slid - Prevslid) > .5) {
            myled4 = !myled4;
            command = 0;
        }
        if (command) {
            fail = 3;
        }
    }
    if (command && (command != 3))
        fail  = 4;
    accelerometer.getInterruptSource();
}


int main() {
    srand( time(NULL));
    printf("Start up    \n");
    lcd.printf("Play Bop-It!\n");
    for (i=0; i< 20; i++) {
        commandtemp = rand() % 10;
        // printf("Before: %i \n \f", commandtemp);
        if (commandtemp == 0) {
            commandtemp = 8;
        }
        if (commandtemp == 9) {
            commandtemp = 8;
        }
        commandtemp = (commandtemp/3) + 1;
        // printf("After: %i     \n", commandtemp);
        commandarray[i] = commandtemp;
    }

    tone.period_ms(1);

    accelerometer.setPowerControl(0x00);
    accelerometer.setDataFormatControl(0x0A);
    accelerometer.setDataRate(ADXL345_3200HZ);
    accelerometer.setInterruptEnableControl(0x01 << 6);
    accelerometer.setInterruptMappingControl(0x00);
    accelerometer.setTapThreshold(0x8);
    accelerometer.setTapDuration(6000);
    accelerometer.setTapAxisControl(0x04);
    accelerometer.setPowerControl(0x08);

    mpr121.write(0x77, 0x00);
    mpr121.write(0x5E, 0x0C);

    AccTap.rise(&AccTapISR);
    accelerometer.getInterruptSource();
    TouchPad.fall(&TouchPadISR);
    TouchPad.mode(PullUp);
    ticker1.attach_us( &Command, time1);
    slid = slider;
    int count = 0;
    while (1) {
        //printf("%X\n",ButtonsPressed);

        //wait(.26);

        __disable_irq();
        if (check) {
            if (command == 1) {
                lcd.cls();
                lcd.printf("Bop-It!\n");
                myled1 = 1;
                myled2 = 0;
                myled3 = 0;
                tone = 0;
            } else if (command == 2) {
                lcd.cls();
                lcd.printf("Touch Three!\n");
                myled1 = 0;
                myled2 = 1;
                myled3 = 0;
                tone = 0;
            } else if (command == 3) {
                lcd.cls();
                lcd.printf("Slide-It!\n");
                myled1 = 0;
                myled2 = 0;
                myled3 = 1;
                tone = 0;
            }
            check = 0;
        }
        if (fail) {
            ticker1.detach();
            ticker2.detach();
            lcd.cls();
            lcd.printf("Failed on: %d\n", fail);
            tone.period_ms(2.3);
            tone = .5;
            wait(.5);
            tone = 0;
            while (1);
        }
        __enable_irq();
    }

}
