
/* Parallax High Speed Continuous Servo
   John Donnal 2018
*/

#ifndef _IR_H
#define _IR_H

/**
 * Includes
 */
#include "mbed.h"

/**
 * 38KHz IR Receiver (for Sony RM-EZ4 Remote) 
 */
class IrIn {

public:

    /**
     * Constructor.
     *
     * @param output mbed pin for input channel.
     */
    IrIn(PinName input);

    /**
     * Decode IR data, blocks until data is received
     */
    int read();
private:

    void falling_edge_();
    void rising_edge_();
    InterruptIn ir_;
    Timer t_;
    int rx_in_progress_;
    int rx_complete_;
    int rx_bits_;
    int msg_;
};

#endif /* CONTINUOUS_SERVO_H */
