#include "Ir.h"
 
 
IrIn::IrIn(PinName input): ir_(input){
    ir_.rise(this, &IrIn::rising_edge_);
    ir_.fall(this, &IrIn::falling_edge_);
    ir_.disable_irq();
    rx_bits_ = 0;
    msg_ = 0x0;
    rx_in_progress_ = 0;
    rx_complete_ = 0;
    t_.start();
}

int IrIn::read(){
    ir_.enable_irq();
    while(!rx_complete_)
        wait(0.1);
    int rx_msg = msg_;
    msg_ = 0x0;
    rx_complete_ = 0;
    rx_bits_ = 0;
    return rx_msg;
}

void IrIn::rising_edge_(){
    char rx_bit = 0x0;
    int dt = t_.read_us();
    
    //make sure we align to a start condition
    if(!rx_in_progress_){
        if(dt>2000 && dt < 2500){
            rx_in_progress_ = 1;
        }
        return;
    }
    if(dt>700)
        rx_bit = 0x1;
    else
        rx_bit = 0x0;
    rx_bits_++;
    msg_ = (msg_ << 1) | rx_bit;
    if(rx_bits_ == 12){
        rx_in_progress_ = 0;
        rx_complete_ = 1;
        ir_.disable_irq();
    }
    
}

void IrIn::falling_edge_(){
    t_.reset();
}