
/* Parallax High Speed Continuous Servo
   John Donnal 2018
*/

#ifndef CONTINUOUS_SERVO_H
#define CONTINUOUS_SERVO_H

/**
 * Includes
 */
#include "mbed.h"

/**
 * Parallax High Speed Continuous Servo Interface.
 */
class ContinuousServo {

public:

    /**
     * Constructor.
     *
     * Drive Parallax servo (ActivityBot)
     * -1: full speed reverse
     *  0: stop
     *  1: full speed forward
     * @param output mbed pin for output channel.
     */
    ContinuousServo(PinName output);

    void speed(float val);
    void stop(void);
private:

    PwmOut servo_;
};

#endif /* CONTINUOUS_SERVO_H */
