#include "mbed.h"
#include <iostream>
#include "uLCD_4DGL.h"
#define PINK 0xF00FF0

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
DigitalOut led1(LED1);
//interrupt page: https://developer.mbed.org/handbook/InterruptIn
InterruptIn upJ(p14);
InterruptIn downJ(p15);
InterruptIn leftJ(p16);
InterruptIn rightJ(p17);
InterruptIn fireJ(p18);

PwmOut haptic(p21);

void vibrate_short(){
    haptic = 1;
    wait(0.1);
    haptic = 0;
    }

using namespace std;


#define BOARD_WIDTH 8
#define BOARD_HEIGHT 16
#define GAME_SPEED 1

const int black = 0;
const int blue = 1;
const int red = 2;
const int pink = 3;
const int blueGerm = 4;
const int redGerm = 5;
const int pinkGerm = 6;

int totalGermCount = 2; 
time_t t1, t2;
double timeDif = 0;

        int myPosX;
        int myPosY;
        int myPiece;
        int myNextPiece;

int myBoard[BOARD_WIDTH][BOARD_HEIGHT];

        bool isFreeBlock(int aXPos, int aYPos)
        {
            
            if(myBoard[aXPos][aYPos] == 0){ 
                 return true; 
                 }else {
                     return false;
                     }
        }
    
        void storePiece(int aXPos, int aYPos, int aColor)
        {

            myBoard[aXPos][aYPos] = aColor;

        }
        
        void DeleteLine(int aXPos, int aYPos, int aDirection)
        {
            vibrate_short();
            for(int j = aYPos; j > 0; j--)
            {
                for(int i = 0; i < BOARD_WIDTH; i++)
                {

                    myBoard[i][j] = myBoard[i][j-1];
                    

                }
            }
        }
        
        bool isPossibleMovementY(int aXPos,int aYPos)
        {
            if((aYPos < BOARD_HEIGHT) && (myBoard[aXPos][aYPos] == 0))
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        
        bool isPossibleMovementX(int aXPos, int aYPos)
        {
            if((aXPos >= 0) && (aXPos < BOARD_WIDTH) && (myBoard[aXPos][aYPos] == 0)){
                return true;
                } else{ 
                return false;
                }   
        }
    
        void deletePossibleLines(void)
        {
            int localGerm = 0;
            
            for(int jj = 0; jj < BOARD_HEIGHT; jj++)
            {
                int theColor2Delete = myBoard[0][jj];
                int colorCount = 0;
                int ii = 0;
                while(ii < BOARD_WIDTH)
                {
                    if ((myBoard[ii][jj] >= 4) && (myBoard[ii][jj] <= 6))
                    {
                        localGerm++;   
                    }
                    
                    if(((myBoard[ii][jj] == theColor2Delete) || 
                        (myBoard[ii][jj] == theColor2Delete + 3)) &&
                        (myBoard[ii][jj] != 0)){
                        colorCount++;
                        }
                    if(myBoard[ii][jj] == black)
                    {
                        break;
                    }
                    ii++;
                }
                if((ii == BOARD_WIDTH) && (colorCount == BOARD_WIDTH)){
                    DeleteLine(0,jj,0);
                    totalGermCount = totalGermCount - localGerm;
                }
            }
        }
        
        bool isGameOver(void)
        {
            if (totalGermCount == 0)
            {
             return true;   
             
            }
            for(int i = 0; i < BOARD_WIDTH; i++)
            {
                if(myBoard[i][0] != 0)
                {
                    return true;
                }
                
                return false;
            }
            return true;
        }
    
        void initializeBoard()
        {
            for (int i = 0; i < BOARD_WIDTH; i++)
            {
                for(int j = 0; j < BOARD_HEIGHT; j++)
                {
                     
                    myBoard[i][j] = black;
                       
                }
            }
            
            myBoard[6][15] = blueGerm;
            myBoard[0][15] = blue;
            myBoard[1][15] = blue;
            myBoard[2][15] = blue;

            myBoard[4][15] = blue;
            myBoard[5][15] = blue;
            
            myBoard[6][14] = redGerm;
            myBoard[0][14] = red;
            myBoard[1][14] = red;
            myBoard[2][14] = red;
            myBoard[3][14] = red;
            myBoard[4][14] = red;

            
            
            
        }


        void DrawScene(void);
        
        


        void DrawPiece(int x, int y, int aColor)
        {

            myBoard[x][y] = aColor;

            
            x = x * 8;
            y = y * 8;

            if (aColor == blue){
            uLCD.filled_rectangle(x, y, x+7, y+7, BLUE);
            }
            
            if (aColor == red){
            uLCD.filled_rectangle(x, y, x+7, y+7, RED);
            }
            
            if (aColor == black){
            uLCD.filled_rectangle(x, y, x+7, y+7, BLACK);
            }
            
            if (aColor == redGerm){
            uLCD.filled_rectangle(x, y, x+7, y+7, RED);
            uLCD.filled_rectangle(x+1, y+1, x+6,y+6,BLACK);
            uLCD.filled_rectangle(x+2,y+2, x+5, y+5, RED);
            }
            
            if (aColor == blueGerm){
            uLCD.filled_rectangle(x, y, x+7, y+7, BLUE);
            uLCD.filled_rectangle(x+1, y+1, x+6,y+6,BLACK);
            uLCD.filled_rectangle(x+2,y+2, x+5, y+5, BLUE);
            }
            
            if (aColor == pinkGerm){
            uLCD.filled_rectangle(x, y, x+7, y+7, PINK);
            uLCD.filled_rectangle(x+1, y+1, x+6,y+6,BLACK);
            uLCD.filled_rectangle(x+2,y+2, x+5, y+5, PINK);
            }
            
        
            
        }

        void DrawRow(int aY)
        {
            for(int i = 0; i < BOARD_WIDTH; i++)
            {
                DrawPiece(i,aY, myBoard[i][aY]);
            }
        }
        
        void DrawBoard()
        {
            for(int j = 0; j<BOARD_HEIGHT; j++)
            {
                DrawRow(j);
            }

        }
        
        int  GetRand(int A, int B)
        {
            return rand() % (B - A + 1) + A;
        }
        
        void initializeGame(void)
        {
            myPiece = GetRand(1,2);
            myPosX = 4;
            myPosY = 0;
            
            myNextPiece = GetRand(0,2);

        }
        
        void CreateNewPiece(void)
        {
            myPiece = myNextPiece;
            myPosX = 4;
            myPosY = 0;
            myNextPiece = GetRand(1,2);
        }
       
        void drawSingle(int x, int y, int color)
        {
            uLCD.filled_rectangle(x, y, x+7, y+7, color);
        }


        void movePillLeft()
            {
               
            if(isPossibleMovementX(myPosX + 1,myPosY)){
                myBoard[myPosX][myPosY] = black;
                myPosX = myPosX + 1;
                }
              //  DrawPiece(myPosX, myPosY, myPiece);
             
            //    
            }
    
        void movePillRight()
        {
           
            if(isPossibleMovementX(myPosX - 1,myPosY)){
            myBoard[myPosX][myPosY] = black;
            myPosX = myPosX-1;
            }
           // DrawPiece(myPosX, myPosY, myPiece);
           
        }
        
        void movePillDown()
        {
          
           // DrawPiece(myPosX, myPosY, black);
           myBoard[myPosX][myPosY] = black;
            myPosY = myPosY + 1;
           // DrawPiece(myPosX, myPosY, myPiece);
           
         
        }


void endGame(void)
{
uLCD.filled_rectangle(0, 0, 128, 128, GREEN);    
wait(10);
exit(0);

}


int main()
{
    
    uLCD.baudrate(3000000);
   
    
    initializeGame();
    initializeBoard();
    
    downJ.rise(&movePillDown);
     leftJ.rise(&movePillLeft);
    rightJ.rise(&movePillRight);
 
 t1 = time(NULL);
 t2 = time(NULL);
while(1){ 
            t2 = time(NULL);
            timeDif = t2 - t1;
            if(timeDif > 1)
            {
                if(isPossibleMovementY(myPosX,myPosY + 1))
                {
                  
                    DrawPiece(myPosX,myPosY, black);
                    myPosY++;
                    DrawPiece(myPosX,myPosY,myPiece);
                    DrawBoard();
                   
                    t2 = time(NULL);
        
                }
                else
                {
                    t1 = time(NULL);
                    storePiece(myPosX,myPosY,myPiece);
                   
                    DrawPiece(myPosX,myPosY,myPiece);
                    deletePossibleLines();
                    
                    if(isGameOver()){
                        endGame();
                    }
                   
                    CreateNewPiece();
                } 
            }
}


}
