#include "mbed.h"
#include "uLCD_4DGL.h"
#include "board.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include <sstream>
#include <string>
#include <iostream>

uLCD_4DGL lcd(p28,p27,p30); // serial tx, serial rx, reset pin;
Serial pc(USBTX, USBRX);
DigitalIn in0(p11);
DigitalIn in1(p12);
DigitalIn in2(p13);
DigitalIn in3(p14);
DigitalIn in4(p15);
DigitalIn in5(p16);
DigitalIn in6(p17);
DigitalIn in7(p18);
DigitalIn in8(p19);




int player1=1;
int player2=2;
int turn =1;
int printout = 0;


void printBoard(int ** board)
{
    lcd.cls();
    lcd.line(0, 42 , 127, 42 , 0xFF0000);
    lcd.line(0, 84 , 127, 84 , 0xFF0000);
    lcd.line(42, 0 , 42, 127, 0xFF0000);
    lcd.line(84, 0, 84, 127, 0xFF0000);
    for(int i=0; i<3; i++) {
        for(int j=0; j<3; j++) {
            if(board[i][j] == 0) {
                lcd.line( j*42+2 , i*42 + 2 ,(j+1)*42-2 , (i+1)*42-2 , GREEN);
                lcd.line( j*42+2 , (i+1)*42 - 2 ,(j+1)*42-2 , (i)*42+2 , GREEN);
            } else if(board[i][j] == 1) {
                lcd.circle(42*j+21, 42*i+21, 19, BLUE);
            }
        }
    }
}
typedef enum GAME_STATE {
    STARTING, PLAYING, OVER, RETURN_ERROR = -1
} GAME_STATE;
HTTPClient http;
EthernetInterface eth;
char str[1024];
int StartNewGame()
{
    char* url = "http://4180.azurewebsites.net/api/TicTacToeGames/New\0";
    HTTPResult ret = http.get(url, str, 1024);
    if (ret > 0) {
        pc.printf("HTTP Error return in StartNewGame\n");
        return -1;
    }
    return atoi(str);
}
int JoinGame()
{
    char* url = "http://4180.azurewebsites.net/api/TicTacToeGames/Join\0";
    HTTPResult ret = http.get(url, str, 1024);
    if (ret > 0) {
        pc.printf("HTTP Error return in JoinGame\n");
        return -1;
    }
    return atoi(str);
}
GAME_STATE GetGameState(int gameId)
{
    string s;
    stringstream host;
    host.clear();
    host  << "http://4180.azurewebsites.net/odata/TicTacToeGames(" << gameId << ")?$select=GameState";
    //printf("**** HOST IS  %s\n", host.str().c_str());
    
    HTTPResult ret = http.get(host.str().c_str(), str, 1024, 15000);
    if (ret > 0) {
        pc.printf("HTTP Error return in GetGameState\n");
        return (GAME_STATE)-1;
    }
    s = string(str);
    if (s.find("\"GameState\":\"STARTING\"") != string::npos)
        return STARTING;
    else if(s.find("\"GameState\":\"PLAYING\"") != string::npos)
        return PLAYING;
    else if(s.find("\"GameState\":\"OVER\"") != string::npos)
        return OVER;
    else
        return RETURN_ERROR;

  //  return (GAME_STATE)atoi(str);
}
void ParseBoard(string str, int** board)
{

    // printf("Entering ParseBoard, got %s\n", str.c_str());
    for (int i = 0; i < str.length(); i++) {
        if (str[i] == '[' || str[i] == ']' || str[i] == ',' || str[i] == '"')
            str[i] = ' ';
    }
    string temp;
    for (int i = 0; i < str.length() - 1; i++) {
        if (!(str[i] == ' ' && str[i+1] == ' ')) {
            temp += str[i];
        }

    }

    str = temp;
    // printf("With changed delimiters %s\n", str.c_str());
    stringstream stream(str);
    int t = 0;
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            stream >> board[i][j];
            //printf("%d\n", board[i][j]);
        }
    }

    /*  for (int i = 0; i < 3; i++) {
        printf("\n[");
        for (int j = 0; j < 3; j++)
            printf("%d ", board[i][j]);
        printf("]");
    }*/
}
int PostMove(int playerId,int gameId, int x, int y)
{
    stringstream host;
    host  << "http://4180.azurewebsites.net/api/TicTacToeGames?gameId=" << gameId << "&playerId=" << playerId << "&moveX=" << x << "&moveY=" << y;
    string s = host.str();
    HTTPText datain("");
    HTTPMap dataout;
    HTTPResult ret = http.post(s.c_str(), dataout, &datain, 10000);
    if (ret > 0) {
        pc.printf("HTTP Error in PostMove");
        return -1;
    }
    return 0;

}
int GetCurrentPlayer(int gameId)
{

    stringstream host;
    host  << "http://4180.azurewebsites.net/odata/TicTacToeGames(" << gameId << ")?$select=CurrentPlayer";
    string s = host.str();
    int retry_count = 5;
    HTTPResult ret = (HTTPResult)1;
    while (ret > 0 & retry_count-- > 0)
        ret = http.get(s.c_str(), str, 1024);
    if (ret > 0) {
        pc.printf("HTTP Error return in GetCurrentPlayer\n");
        return -1;
    }
    s = string(str);
    int pos = s.find("\"CurrentPlayer\":");
    if (pos == string::npos)
        return -1;
    return s[pos+16] - '0';
}
int GetWinner(int gameId)
{

    stringstream host;
    host  << "http://4180.azurewebsites.net/odata/TicTacToeGames(" << gameId << ")?$select=Winner";
    string s = host.str();
    int retry_count = 5;
    HTTPResult ret = (HTTPResult)1;
    while (ret > 0 & retry_count-- > 0)
        ret = http.get(s.c_str(), str, 1024);
    if (ret > 0) {
        pc.printf("HTTP Error return in GetWinner\n");
        return -1;
    }
    s = string(str);
    int pos = s.find("\"Winner\":");
    if (pos == string::npos)
        return -1;
    return s[pos+9] - '0';
}
int GetBoardState(int gameId, int** board)
{
    stringstream host;
    host  << "http://4180.azurewebsites.net/odata/TicTacToeGames(" << gameId << ")?$select=BoardState";
    string s = host.str();
    int retry_count = 5;
    HTTPResult ret = (HTTPResult)1;
    while (ret > 0 & retry_count-- > 0)
        ret = http.get(s.c_str(), str, 1024);
    if (ret > 0) {
        pc.printf("HTTP Error return in GetBoardState\n");
        return -1;
    }
    s = string(str);
    int pos = s.find("\"BoardState\":");
    if (pos == string::npos)
        return -1;

    ParseBoard(s.substr(pos +13, string::npos), board);
    return 0;
}
string GameStateToString(GAME_STATE state)
{
    switch(state) {
        case STARTING:
            return "STARTING";
        case PLAYING:
            return "PLAYING";
        case OVER:
            return "OVER";
        default:
        case RETURN_ERROR:
            return "ERROR";
    }
}
int GetSerialInput()
{
    return pc.getc() - '0';
}
void ScanForMove(int* x, int* y, int** board)
{
    // the following commented section can be used to input moves over pc terminal by pressing 00 for move at location [0,0]
    /*
    pc.printf("Entering scan\n");
    *x = GetSerialInput();
    *y = GetSerialInput();
    return;
    */
    
    while(1) {
        if (!in0 && board[0][0]== -1) {
            *x = 0;
            *y = 0;
            return;
        } else if (!in1 && board[0][1] == -1) {
            *x = 0;
            *y = 1;
            return;
        } else if (!in2 && board[0][2] == -1) {
            *x = 0;
            *y = 2;
            return;
        } else if (!in3 && board[1][0] == -1) {
            *x = 1;
            *y = 0;
            return;
        } else if (!in4 && board[1][1] == -1) {
            *x = 1;
            *y = 1;
            return;
        } else if (!in5 && board[1][2] == -1) {
            *x = 1;
            *y = 2;
            return;
        } else if (!in6 && board[2][0] == -1) {
            *x = 2;
            *y = 0;
            return;
        } else if (!in7 && board[2][1] == -1) {
            *x = 2;
            *y = 1;
            return;
        } else if (!in8 && board[2][2] == -1) {
            *x = 2;
            *y = 2;
            return;
        }
        wait(0.2);
    }
}
int main()
{
    pc.printf("Ethernet connecting...\n");
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\n", eth.getIPAddress());

    in0.mode(PullUp);
    in1.mode(PullUp);
    in2.mode(PullUp);
    in3.mode(PullUp);
    in4.mode(PullUp);
    in5.mode(PullUp);
    in6.mode(PullUp);
    in7.mode(PullUp);
    in8.mode(PullUp);
    lcd.baudrate(3000000);

    // START GAME OR JOIN GAME
    // FORMAT THIS TO LOOK PRETTY ON LCD
    int gameId = -1;
    int playerId = -1;
    bool reprint = true;
    do {
        if (reprint) {
            lcd.cls();
            lcd.printf("Button 0: Start New Game\nButton 1: Join Existing Game");
            reprint = false;
        }
        // I'm assuming by looking at the code that
        // you guys made the buttons active low so inverting the read
        if (!in0 /*|| true*/) {
            // Start Game
            gameId = StartNewGame();
            if (gameId < 1) { // fail
                lcd.printf("Failed to start a new game!\n");
                wait(1.5);
                reprint = true;
            } else
                playerId = 0;

        } else if(!in1) {
            gameId = JoinGame();
            if (gameId < 1) { // fail
                lcd.printf("Failed to join game, try making one!\n");
                wait(1.5);
                reprint = true;
            } else
                playerId = 1;
        }
    } while (gameId < 1);
    lcd.cls();

    if (playerId == 1){
        pc.printf("Successfully joined game %d!\n", gameId);
        lcd.printf("Successfully joined game %d!\n", gameId);
        }
    else{
        pc.printf("Successfully started game %d!\n", gameId);
        lcd.printf("Successfully started game %d!\n", gameId);
        }

    wait(1.5);

    Board board;
    lcd.cls();
    lcd.printf("Waiting for game to start...\n");
    // wait for game to start
    while(GetGameState(gameId) != PLAYING) {
        wait(2);
    }

    // Main Game Loop
    lcd.cls();

    while(1) {
        GAME_STATE state = GetGameState(gameId);
        if (state == OVER)
            break; // game over
        // wait for turn
        while(GetCurrentPlayer(gameId) != playerId){ wait(1.5); }
        GetBoardState(gameId, board.get_board());
        printBoard(board.get_board());
                    
        state = GetGameState(gameId);
        if (state == OVER)
            break;
        int moveX, moveY;
        ScanForMove(&moveX,&moveY, board.get_board());
        PostMove(playerId, gameId, moveX, moveY);
        GetBoardState(gameId, board.get_board());
        printBoard(board.get_board());
        wait(2);
    }
    int winner = GetWinner(gameId);
    pc.printf("Player %d Won!\n", winner);
    lcd.printf("Player %d Won!\n", winner);
    /* lcd.line(0, 42 , 127, 42 , 0xFF0000);
     lcd.line(0, 84 , 127, 84 , 0xFF0000);
     lcd.line(42, 0 , 42, 127, 0xFF0000);
     lcd.line(84, 0, 84, 127, 0xFF0000);*/
/*
    while (true) {
        if(!in0)
            printout = 1;
        else if(!in1)
            printout = 2;
        else if(!in2)
            printout = 3;
        else if(!in3)
            printout = 4;
        else if(!in4)
            printout = 5;
        else if(!in5)
            printout = 6;
        else if(!in6)
            printout = 7;
        else if(!in7)
            printout = 8;
        else if(!in8)
            printout = 9;
        else
            printout = 0;


        if(printout>0) {
            bool valid = board.updateBoard(turn, printout-1);

            if(valid) {
                output = board.get_board();
                printBoard(output);
                printout=0;
                int victory = board.check_victory(turn);
                if(victory ==1) {
                    lcd.cls();
                    lcd.printf("player 1 win!");
                    return 0;
                } else if(victory == 2) {
                    lcd.cls();
                    lcd.printf("player 2 win!");
                    return 0;
                }
                if(turn ==1)
                    turn =2;
                else
                    turn =1;
            }
        }
        Thread::wait(400);
    }
    */

}



int TEST_FN()
{
    pc.printf("Trying Start New Game...\n");
    int game = StartNewGame();
    wait(1);
    while (JoinGame() != game) {
        wait(0.5);
    }
    int player = 0;
    Board b;
    printf("Joined Game %d\n", game);
    bool sentinel = true;
    while (sentinel) {
        GetBoardState(game, b.get_board());
        printBoard(b.get_board());
        if (player == 0) {
            PostMove(player, game, 0, 0);
            pc.printf("Exited first post move\n");
            player = 1;
        } else {
            PostMove(1, game, 1, 1);
            sentinel = false;
        }
        wait(0.5);
    }
    pc.printf("Done with move\n");
    wait(0.5);
    GetBoardState(game, b.get_board());
    printBoard(b.get_board());

    pc.printf("Got: %d\n\n", game);
    pc.printf("Trying GetGameState for Game %d...\n", game);
    pc.printf("Got: %s\n\n", GameStateToString(GetGameState(game)).c_str());
    pc.printf("Trying Join Game...\n");
    game = JoinGame();
    wait(1);
    pc.printf("Got: %d\n\n", game);
    //pc.printf("Trying GetGameState for Game %d...\n", game);
    //pc.printf("Got: %s\n\n", GameStateToString(GetGameState(game)).c_str());
    pc.printf("Trying GetBoardState for Game %d...\n", game);
    // Board b;
    wait(1);
    pc.printf("Got: %d\n\n", GetBoardState(game, b.get_board()));
    pc.printf("Testing over****\n");
    /*pc.printf("%d\n", sizeof(str));
    HTTPResult ret = http.get("http://4180.azurewebsites.net/api/TicTacToeGames/New", str, 4096);//http.get("http://4180.azurewebsites.net/", str, 4096);
    if (ret > 0)
    pc.printf("Return error\n");
    for (int i = 0; i < 4096;i++){
    if (str[i] == '1'|| str[i] == '2' || str[i] == '3' || str[i] == '4')
    pc.printf("HERE %d\n", i);
    pc.putc(str[i]);
    pc.printf("\n");
    }*/
    return 0;
    TCPSocketConnection socket;


    int r = socket.connect("4180.azurewebsites.net", 80);
    if (r != 0)
        pc.printf("Failed to connect to 4180.azurewebsites.net:80!\r\n");
    char http_cmd[] = "GET / HTTP/1.0\n\n";
    socket.send_all(http_cmd, sizeof(http_cmd)-1);

    char buff[300];
    int rtn;
    while (true) {
        rtn = socket.receive(buff, sizeof(buff)-1);
        if (rtn <= 0)
            break;
        buff[rtn] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", rtn, buff);
    }
    pc.printf("Closing socket...\n");
    socket.close();
    eth.disconnect();
}

