#include "mbed.h"
#include "uLCD_4DGL.h"


DigitalOut _led1(LED1);
DigitalOut _led2(LED2);
DigitalOut _led3(LED3);
DigitalOut _led4(LED4);
AnalogIn pot(p20);
uLCD_4DGL lcd(p28, p27, p30);

const int startX = SIZE_X / 3;
const int stopX = startX * 2;
const int stopY = SIZE_Y;
int startY = 0;
void PrintLCDGraph(float value){
    int prevY = startY;
    startY = SIZE_Y * (1 - value);
    // clear part of graph that doesn't overlap between samples
    lcd.filled_rectangle(startX, prevY, stopX, startY, BLACK);
    lcd.filled_rectangle(startX, startY, stopX, stopY, RED);
}
void PrintLEDGraph(float value){
    _led1 = (value >= 0.2) ? 1 : 0;
    _led2 = (value >= 0.4) ? 1 : 0;
    _led3 = (value >= 0.6) ? 1 : 0;
    _led4 = (value >= 0.8) ? 1 : 0;
}
int main() {
    float sample;
    while(1) {
        sample = pot;
        PrintLEDGraph(sample);
        PrintLCDGraph(sample);
        wait(0.1);
    }
}
