#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include <vector>

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
uLCD_4DGL lcd(p28, p27, p30);
DigitalIn refreshButton(p21);
Serial pc(USBTX, USBRX);
Mutex mutex;

// Function declarations
void checkRefreshButton();
void screensaver(void const*);

int main() {
    refreshButton.mode(PullUp);
    lcd.background_color(0x00000000);
    
    // Draw some initial objects
    //int WHITE = 0x00FFFFFF;
    lcd.filled_circle(64, 64, 25, WHITE);
    lcd.filled_circle(25, 45, 25, WHITE);
    lcd.filled_circle(90, 90, 25, WHITE);
    lcd.filled_circle(90, 35, 25, WHITE);
    Thread screensave(screensaver);
    
    while(1) {
        // Lock the LCD and check to see if screensaver
        // should be (de)activated
        mutex.lock();
        lcd.checkActiveScreenTime();
        mutex.unlock();
        
        // Check state of screen refresh pushbutton
        checkRefreshButton();
        led1 = !led1;
        Thread::wait(500);   
    }
}


// Graphics for the screensaver
void screensaver(void const* p) {

    // Show the screensaver
    int trail_size = 64;
    int xbound_l = 0;
    int xbound_r = 127;
    int ybound_t = 0;
    int ybound_b = 127;
    
    int x = 64;
    int y = 64;
    int px = 0;
    int py = 0;
    int dx = 2;
    int dy = 1;
    int loopCounter = 0;
    
    uint8_t R = 0xFF;
    uint8_t G = 0x00;
    uint8_t dG = 0x02;
    uint8_t B = 0xFF;
    uint8_t dB = 0x02;
    uint32_t COLOR = 0x0;
    
    lcd.baudrate(3000000);
    
    std::vector<int> trail_px;
    std::vector<int> trail_py;
               
    while(1) {
        if (!lcd.isInScreensaverMode()) {
            Thread::yield();
        } else {
            
            if (loopCounter++ == 100000) {
                COLOR=0x0;
                R = ~B;
                G += dG;
                B += dB;
                
                COLOR |= R << 16;
                COLOR |= G << 8;
                COLOR |= B;
                COLOR = COLOR ^ 0xFFFFFF;
            
                px = x;
                py = y;
                
                trail_px.push_back(px);
                trail_py.push_back(py);
                if(trail_px.size() > trail_size) {
                    lcd.pixel(*trail_px.begin(), *trail_py.begin(), 0x0, true);
                    trail_px.erase( trail_px.begin() );
                    trail_py.erase( trail_py.begin() );
                }
                
                if(trail_px.size() > trail_size) trail_px.pop_back();
                if(trail_py.size() > trail_size) trail_py.pop_back();
                
                if((x+dx) >= xbound_r || (x+dx) <= xbound_l) dx *= -1;
                if((y+dy) >= ybound_b || (y+dy) <= ybound_t) dy *= -1;
                
                x += dx;
                y += dy;
                
                mutex.lock();
                lcd.pixel(x, y, COLOR, true);
                mutex.unlock();
            
                loopCounter = 0;
            }
        }
    }
}


// Check the state of the screen refresh pushbutton
void checkRefreshButton() {
    if (refreshButton == 0) {
        if (lcd.isInScreensaverMode()) {
            mutex.lock();
            lcd.exitScreensaverMode();
            mutex.unlock();
        }
        else {
            lcd.reportScreenInteraction();
        }
    }
}