#ifndef __test_h__
#define __test_h__

template<class TData>
struct test_t
{
    const char* description;
    test_t() : description(""){}
    test_t(const char* desc) : description(desc) {}
    
    typedef TData data_type;
    
    virtual void test(data_type& data) =0;    
    void operator()(data_type& data) {test(data);}
};

template<class TData>
int time_test_execution(Timer& timer,test_t<TData>& test,TData& data,int repeat=1000000)
{
    timer.reset();
    for(size_t i=0;i<repeat;i++) {
        timer.start();
        test(data);
        timer.stop(); // stop accumulating ticks until the next iteration.
    }
   return timer.read_ms();
}

template<class TData>
int time_test_execution(Timer& timer,test_t<TData> test,int repeat=1000000)
{
    test_t<TData>::data_type data;
    return time_test_execution(timer,test,data,repeat);
}

#endif //__test_h__