#include "mbed.h"
#include "raw_tests.h"

extern Serial pc;
extern Timer timer;

accumulate_test<uint8_t> BAT("Byte accumulator test");
accumulate_test<char> CAT("char accumulator test");
accumulate_test<float> FAT("float accumulator test");

raw_bit_mask_test_set_all<uint8_t> RBMT_BSA("RAW: Set all bits on byte test");
raw_bit_mask_test_clear_all<uint8_t> RBMT_BCA("RAW: clear all bits on byte test");
raw_bit_mask_test_toggle_all<uint8_t> RBMT_BTA("RAW: toggle all bits on byte test");

raw_bit_mask_test_set_all<uint16_t> RBMT_UI16SA("RAW: Set all bits on uint16_t test");
raw_bit_mask_test_clear_all<uint16_t> RBMT_UI16CA("RAW: clear all bits on uint16_t test");
raw_bit_mask_test_toggle_all<uint16_t> RBMT_UI16TA("RAW: toggle all bits on uint16_t test");

raw_bit_mask_test_set_all<uint32_t> RBMT_UI32SA("RAW: Set all bits on uint32_t test");
raw_bit_mask_test_clear_all<uint32_t> RBMT_UI32CA("RAW: clear all bits on uint32_t test");
raw_bit_mask_test_toggle_all<uint32_t> RBMT_UI32TA("RAW: toggle all bits on uint32_t test");

raw_bit_mask_test_set_all<uint64_t> RBMT_UI64SA("RAW: Set all bits on uint64_t test");
raw_bit_mask_test_clear_all<uint64_t> RBMT_UI64CA("RAW: clear all bits on uint64_t test");
raw_bit_mask_test_toggle_all<uint64_t> RBMT_UI64TA("RAW: toggle all bits on uint64_t test");

raw_bit_mask_test_left_shift_1<uint64_t> RBMT_UI64LS1("RAW: << 1 on uint64_t test");
raw_bit_mask_test_left_shift_1<uint32_t> RBMT_UI32LS1("RAW: << 1 on uint32_t test");
raw_bit_mask_test_left_shift_1<uint16_t> RBMT_UI16LS1("RAW: << 1 on uint16_t test");
raw_bit_mask_test_left_shift_1<uint8_t> RBMT_UI8LS1("RAW: << 1 on uint8_t test");

raw_bit_mask_test_right_shift_1<uint8_t> RBMT_UI8RS1("RAW: >> 1 on uint8_t test");
raw_bit_mask_test_right_shift_1<uint16_t> RBMT_UI16RS1("RAW: >> 1 on uint16_t test");
raw_bit_mask_test_right_shift_1<uint32_t> RBMT_UI32RS1("RAW: >> 1 on uint32_t test");
raw_bit_mask_test_right_shift_1<uint64_t> RBMT_UI64RS1("RAW: >> 1 on uint64_t test");


void execute_raw_tests()
{
  pc.printf("execute_raw_tests \r\n\r\n");
  uint8_t byte;
  char chr;
  uint16_t ui16;
  uint32_t ui32;
  uint64_t ui64;
  float f;
  byte=0,chr=0,ui16=0,ui32=0,ui64=0,f=0;
  pc.printf("BAT - %d ms\n",time_test_execution(timer,BAT,byte));
  pc.printf("CAT - %d ms\n",time_test_execution(timer,CAT,chr));
  pc.printf("FAT - %d ms\n",time_test_execution(timer,FAT,f));
  
  byte=0,chr=0,ui16=0,ui32=0,ui64=0,f=0;
  pc.printf("RBMT_BSA pre: %02x",byte);
  RBMT_BSA.test(byte);
  pc.printf(" post: %02x\n",byte);
  
  pc.printf("RBMT_BCA pre: %02x",byte);
  RBMT_BCA.test(byte);
  pc.printf(" post: %02x\n",byte);
  
  pc.printf("RBMT_BTA pre: %02x",byte);
  RBMT_BTA.test(byte);
  pc.printf(" post: %02x\n",byte);
  
  pc.printf("RBMT_BSA - %d ms\n",time_test_execution(timer,RBMT_BSA,byte));
  pc.printf("RBMT_BCA - %d ms\n",time_test_execution(timer,RBMT_BCA,byte));
  pc.printf("RBMT_BTA - %d ms\n",time_test_execution(timer,RBMT_BTA,byte));
  pc.printf("RBMT_UI8RS1 - %d ms\n",time_test_execution(timer,RBMT_UI8RS1,byte));
  pc.printf("RBMT_UI8LS1 - %d ms\n",time_test_execution(timer,RBMT_UI8LS1,byte));

  
  byte=0,chr=0,ui16=0,ui32=0,ui64=0,f=0;
  pc.printf("RBMT_UI16SA - %d ms\n",time_test_execution(timer,RBMT_UI16SA,ui16));
  pc.printf("RBMT_UI16CA - %d ms\n",time_test_execution(timer,RBMT_UI16CA,ui16));
  pc.printf("RBMT_UI16TA - %d ms\n",time_test_execution(timer,RBMT_UI16TA,ui16));
  pc.printf("RBMT_UI16RS1 - %d ms\n",time_test_execution(timer,RBMT_UI16RS1,ui16));
  pc.printf("RBMT_UI16LS1 - %d ms\n",time_test_execution(timer,RBMT_UI16LS1,ui16));


  byte=0,chr=0,ui16=0,ui32=0,ui64=0,f=0;
  pc.printf("RBMT_UI32SA - %d ms\n",time_test_execution(timer,RBMT_UI32SA,ui32));
  pc.printf("RBMT_UI32CA - %d ms\n",time_test_execution(timer,RBMT_UI32CA,ui32));
  pc.printf("RBMT_UI32TA - %d ms\n",time_test_execution(timer,RBMT_UI32TA,ui32));
  pc.printf("RBMT_UI32RS1 - %d ms\n",time_test_execution(timer,RBMT_UI32RS1,ui32));
  pc.printf("RBMT_UI32LS1 - %d ms\n",time_test_execution(timer,RBMT_UI32LS1,ui32));

  byte=0,chr=0,ui16=0,ui32=0,ui64=0,f=0;
  pc.printf("RBMT_UI64SA - %d ms\n",time_test_execution(timer,RBMT_UI64SA,ui64));
  pc.printf("RBMT_UI64CA - %d ms\n",time_test_execution(timer,RBMT_UI64CA,ui64));
  pc.printf("RBMT_UI64TA - %d ms\n",time_test_execution(timer,RBMT_UI64TA,ui64));
  pc.printf("RBMT_UI64RS1 - %d ms\n",time_test_execution(timer,RBMT_UI64RS1,ui64));
  pc.printf("RBMT_UI64LS1 - %d ms\n",time_test_execution(timer,RBMT_UI64LS1,ui64));







}
