#ifndef __misc_h__
#define __misc_h__

#include "mbed.h"
#include "bit_storage.h"
#include "misc.h"

extern Serial pc;

template<
    size_t BitSize, 
    class TStorageType,
    bool MSBInIndexZero
>
void describe(bit_storage_t<BitSize,TStorageType,MSBInIndexZero>& reg)
{
      size_t high_bit=reg.bit_size()-1;
      size_t low_bit_byte_idx=reg.byte_index_of(0);
      size_t low_bit_element_idx=reg.element_index_of(0);
      size_t high_bit_byte_idx=reg.byte_index_of(high_bit);
      size_t high_bit_element_idx=reg.element_index_of(high_bit);
      pc.printf("%d bit; %d storage elements of size %d; %d data bytes; %d type size bytes.\r\n", 
      reg.bit_size(), 
      reg.element_count(),
      reg.element_size(),
      reg.byte_count(),
      sizeof(reg));
      // dump out the bits using the getters.
      pc.printf("bits:");
      for(int i=reg.bit_size()-1;i>=0;i--) {
          pc.printf("%d",reg.get(i) ? 1 : 0);
      }
      pc.printf("\r\n");
      // dump out the bits from the a raw element array.
      pc.printf("element index of low bit:%d\r\n",low_bit_element_idx);
      pc.printf("element index of high bit(%d):%d\r\n",high_bit,high_bit_element_idx);
      pc.printf("raw elements (hex):");
      char format[20];
      sprintf(format," %%0%d%s", reg.element_size()*2,reg.element_size()>=sizeof(uint64_t) ? "llx":"x");
      for(int b=0;b<reg.element_count();b++) {
          pc.printf(format,reg.element(b));
      }
      pc.printf("\r\n");

      // dump out the bits from the a raw byte array.
      pc.printf("byte index of low bit:%d\r\n",low_bit_byte_idx);
      pc.printf("byte index of high bit(%d):%d\r\n",high_bit,high_bit_byte_idx);
      pc.printf("raw bytes (hex):");
      for(int b=0;b<reg.byte_count();b++) {
          pc.printf(" %02x",reg.byte(b));
      }
      pc.printf("\r\n");
}

#endif //#ifndef __misc_h__