#ifndef __bitset_test_h__
#define __bitset_test_h__
#include <bitset>
#include "test.h"


template<size_t bits>
struct bitset_test_set_all 
    : public test_t<
        std::bitset<bits>
    >
{    
    bitset_test_set_all() : test_t<
        std::bitset<bits>
    >("bitset test - set all") {}
    
    bitset_test_set_all(const char* desc) : test_t<std::bitset<bits>>(desc) {}

    virtual void test(std::bitset<bits>& data) 
    { 
        data.set();
    }
};


template<size_t bits>
struct bitset_test_reset_all 
    : public test_t<
        std::bitset<bits>
    >
{    
    bitset_test_reset_all() : test_t<
        std::bitset<bits>
    >("bitset test - reset all") {}
    
    bitset_test_reset_all(const char* desc) : test_t<std::bitset<bits>>(desc) {}

    virtual void test(std::bitset<bits>& data) 
    { 
        data.set();
    }
};

template<size_t bits>
struct bitset_test_flip_all 
    : public test_t<
        std::bitset<bits>
    >
{    
    bitset_test_flip_all() : test_t<
        std::bitset<bits>
    >("bitset test - flip all") {}
    
    bitset_test_flip_all(const char* desc) : test_t<std::bitset<bits>>(desc) {}

    virtual void test(std::bitset<bits>& data) 
    { 
        data.set();
    }
};

template<size_t bits,size_t shift>
struct bitset_test_shift_left
    : public test_t<
        std::bitset<bits>
    >
{    
    bitset_test_shift_left() : test_t<
        std::bitset<bits>
    >("bitset test - set all") {}
    
    bitset_test_shift_left(const char* desc) : test_t<std::bitset<bits>>(desc) {}

    virtual void test(std::bitset<bits>& data) 
    { 
        data <<= shift;
    }
};

template<size_t bits,size_t shift>
struct bitset_test_shift_right
    : public test_t<
        std::bitset<bits>
    >
{    
    bitset_test_shift_right() : test_t<
        std::bitset<bits>
    >("bitset test - set all") {}
    
    bitset_test_shift_right(const char* desc) : test_t<std::bitset<bits>>(desc) {}

    virtual void test(std::bitset<bits>& data) 
    { 
        data >>= shift;
    }
};

void execute_bitset_tests();

#endif //__bitset_test_h__