#include <bitset>
#include "mbed.h"
#include "misc.h"
#include "test.h"
#include "bitset_tests.h"

extern Serial pc;
extern Timer timer;

template<size_t bit_size>
void execute_bitset_timed_tests()
{
  std::bitset<bit_size> bits;
  bitset_test_set_all<bit_size> set_all_test;
  bitset_test_reset_all<bit_size> reset_all_test;
  bitset_test_flip_all<bit_size> flip_all_test;
  bitset_test_shift_left<bit_size,1> shift_left_1_test;
  bitset_test_shift_right<bit_size,1> shift_right_1_test;
  
  bitset_test_shift_left<bit_size,bit_size/3> shift_left_1_third_test;
  bitset_test_shift_right<bit_size,bit_size/3> shift_right_1_third_test;
  
  pc.printf("testing bitset<%d>\r\n",bit_size);
  pc.printf("set_all - %d ms\r\n",time_test_execution(timer,set_all_test,bits));
  pc.printf("reset_all - %d ms\r\n",time_test_execution(timer,reset_all_test,bits));
  pc.printf("flip_all - %d ms\r\n",time_test_execution(timer,flip_all_test,bits));
  pc.printf(" bits << 1 - %d ms\r\n",time_test_execution(timer,shift_left_1_test,bits));
  pc.printf(" bits >> 1 - %d ms\r\n",time_test_execution(timer,shift_right_1_test,bits));
  pc.printf(" bits << 1/3 - %d ms\r\n",time_test_execution(timer,shift_left_1_third_test,bits));
  pc.printf(" bits >> 1/3 - %d ms\r\n",time_test_execution(timer,shift_right_1_third_test,bits));
}


void execute_bitset_tests()
{
    /*
    execute_bitset_timed_tests<8>();
    execute_bitset_timed_tests<16>();
    execute_bitset_timed_tests<32>();
    execute_bitset_timed_tests<64>();
    */
    execute_bitset_timed_tests<512>();
}