#ifndef __bit_storage_tests_h__
#define __bit_storage_tests_h__
#include "test.h"
#include "bit_storage.h"

template<size_t bits, class storage_type,bool msb_index_zero>
struct bit_storage_test_set_all 
    : public test_t<
        bit_storage_t<bits, storage_type, msb_index_zero> 
    >
{    
    bit_storage_test_set_all() : test_t<
        bit_storage_t<bits, storage_type, msb_index_zero>
    >("bit_storage_t test - set all") {}
    
    bit_storage_test_set_all(const char* desc) : test_t<
        bit_storage_t<bits, storage_type, msb_index_zero>
    >(desc) {}

    virtual void test(bit_storage_t<bits, storage_type, msb_index_zero>& data) 
    { 
        data.set_all();
    }
};


template<size_t bits, class storage_type,bool msb_index_zero>
struct bit_storage_test_clear_all 
    : public test_t<
        bit_storage_t<bits, storage_type, msb_index_zero> 
    >
{
     typedef bit_storage_t<bits, storage_type, msb_index_zero> TStorage;

    bit_storage_test_clear_all() : test_t<TStorage>("bit_storage_t test - clear all") {}
    bit_storage_test_clear_all(const char* desc) : test_t<TStorage>(desc) {}

    virtual void test(TStorage& data) { 
        data.clear_all();
    }
};

template<size_t bits, class storage_type,bool msb_index_zero>
struct bit_storage_test_toggle_all 
    : public test_t<
        bit_storage_t<bits, storage_type, msb_index_zero> 
    >
{
    typedef bit_storage_t<bits, storage_type, msb_index_zero> TStorage;
    
    bit_storage_test_toggle_all() : test_t<TStorage>("bit_storage_t test - toggle all") {}
    bit_storage_test_toggle_all(const char* desc) : test_t<TStorage>(desc) {}

    virtual void test(TStorage& data) { 
        data.toggle_all();
    }
};

template<size_t bits, class storage_type,bool msb_index_zero>
struct bit_storage_test_left_shift_1_third
    : public test_t<
        bit_storage_t<bits, storage_type, msb_index_zero> 
    >
{
    typedef bit_storage_t<bits, storage_type, msb_index_zero> TStorage;
    
    bit_storage_test_left_shift_1_third() : test_t<TStorage>("bit_storage_t test - << bitsize/3") {}
    bit_storage_test_left_shift_1_third(const char* desc) : test_t<TStorage>(desc) {}

    virtual void test(TStorage& data) { 
        data.shift_left(bits/3);
    }
};

template<size_t bits, class storage_type,bool msb_index_zero>
struct bit_storage_test_left_shift_1
    : public test_t<
        bit_storage_t<bits, storage_type, msb_index_zero> 
    >
{
    typedef bit_storage_t<bits, storage_type, msb_index_zero> TStorage;
    
    bit_storage_test_left_shift_1() : test_t<TStorage>("bit_storage_t test - << 1") {}
    bit_storage_test_left_shift_1(const char* desc) : test_t<TStorage>(desc) {}

    virtual void test(TStorage& data) { 
        data.shift_left(1);
    }
};

template<size_t bits, class storage_type,bool msb_index_zero>
struct bit_storage_test_right_shift_1_third
    : public test_t<
        bit_storage_t<bits, storage_type, msb_index_zero> 
    >
{
    typedef bit_storage_t<bits, storage_type, msb_index_zero> TStorage;
    
    bit_storage_test_right_shift_1_third() : test_t<TStorage>("bit_storage_t test - << bitsize/3") {}
    bit_storage_test_right_shift_1_third(const char* desc) : test_t<TStorage>(desc) {}

    virtual void test(TStorage& data) { 
        data.shift_right(bits/3);
    }
};

template<size_t bits, class storage_type,bool msb_index_zero>
struct bit_storage_test_right_shift_1
    : public test_t<
        bit_storage_t<bits, storage_type, msb_index_zero> 
    >
{
    typedef bit_storage_t<bits, storage_type, msb_index_zero> TStorage;
    
    bit_storage_test_right_shift_1() : test_t<TStorage>("bit_storage_t test - << 1") {}
    bit_storage_test_right_shift_1(const char* desc) : test_t<TStorage>(desc) {}

    virtual void test(TStorage& data) { 
        data.shift_right(1);
    }
};



void execute_bit_storage_tests();

#endif //__bit_storage_tests_h__